/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.generator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;
import ru.softlogic.generator.GenerateVisitor;
import ru.softlogic.generator.Options;
import ru.softlogic.generator.OptionsParser;
import ru.softlogic.generator.Utils;
import ru.softlogic.generator.ValidateVisitor;
import ru.softlogic.generator.walker.TreeWalker;

public class FileListGenerator {
    private static Options options;

    public static void main(String[] args) {
        options = OptionsParser.parse(new File(Utils.getScheme(), "options.properties"));
        File root = Utils.getRoot();
        TreeWalker tw = new TreeWalker();
        if (args.length == 0) {
            System.out.println("Full processing");
            if (FileListGenerator.validate(tw, root)) {
                FileListGenerator.generate(tw, root);
            } else {
                System.exit(1);
            }
        } else if ("val".equals(args[0])) {
            System.out.println("Validate only");
            System.exit(FileListGenerator.validate(tw, root) ? 0 : 1);
        } else if ("gen".equals(args[0])) {
            System.out.println("Generate only");
            FileListGenerator.generate(tw, root);
        } else {
            System.out.println("Wrong param, Use java -jar FileListGenerator.jar [gen|val]");
        }
    }

    private static boolean validate(TreeWalker tw, File root) {
        ValidateVisitor vv = new ValidateVisitor(root, options);
        long t1 = System.currentTimeMillis();
        tw.walk(root, root, vv);
        FileListGenerator.showErrors(vv);
        System.out.println("Total processing time: " + (System.currentTimeMillis() - t1) + "ms");
        return !vv.hasErrors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generate(TreeWalker tw, File root) {
        Utils.updateVersion();
        GenerateVisitor gv = new GenerateVisitor(root, options.getExcludeGenerate());
        tw.walk(root, root, gv);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter("list.xml");
            pw.write(gv.getResult());
            pw.close();
            File list = new File(root, "list.xml");
            long listCrc = Utils.calculateChecksum(list);
            Utils.setListParams(listCrc, list.length(), list.lastModified());
            System.exit(0);
        }
        catch (FileNotFoundException ex) {
            System.out.println("Can't create list.xml: " + ex.getMessage());
            System.exit(2);
        }
        finally {
            if (pw != null && pw.checkError()) {
                pw.close();
            }
        }
    }

    private static void showErrors(ValidateVisitor vv) {
        List<String> err = vv.getWrongCharErrors();
        if (!err.isEmpty()) {
            System.out.println("-------------------------------------------------------------------------------------------------");
            System.out.println("Files with wrong characters in filename:");
            for (String name : err) {
                System.out.println("    " + name);
            }
            System.out.println("--- Errors: " + err.size() + "\n\n");
        }
        if (!(err = vv.getWrongCaseErrors()).isEmpty()) {
            System.out.println("-------------------------------------------------------------------------------------------------");
            System.out.println("Files with wrong cases in filename:");
            for (String name : err) {
                System.out.println("    " + name);
            }
            System.out.println("--- Errors: " + err.size() + "\n\n");
        }
        err = vv.getFormsErrors();
        err.addAll(vv.getScenarioErrors());
        if (!err.isEmpty()) {
            System.out.println("-------------------------------------------------------------------------------------------------");
            System.out.println("XML errors:");
            for (String name : err) {
                System.out.println(name);
            }
            System.out.println("--- Errors: " + err.size() + "\n\n");
        }
        System.out.println("Total errors: " + vv.getTotalErrors());
    }
}

