/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Component;
import net.java.dev.designgridlayout.AbstractClassBasedHeightGrowPolicy;
import net.java.dev.designgridlayout.HeightGrowPolicy;
import net.java.dev.designgridlayout.MultiComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MultiComponentHeightGrowPolicy
extends AbstractClassBasedHeightGrowPolicy<MultiComponent> {
    private final HeightGrowPolicy _defaultPolicy;

    public MultiComponentHeightGrowPolicy(HeightGrowPolicy defaultPolicy) {
        super(MultiComponent.class);
        this._defaultPolicy = defaultPolicy;
    }

    @Override
    protected boolean componentCanGrowHeight(MultiComponent component) {
        for (Component child : component.getComponents()) {
            if (!this._defaultPolicy.canGrowHeight(child)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int componentComputeExtraHeight(MultiComponent component, int extraHeight) {
        int actualHeight = 0;
        for (Component child : component.getComponents()) {
            if (!this._defaultPolicy.canGrowHeight(child)) continue;
            actualHeight = Math.max(actualHeight, this._defaultPolicy.computeExtraHeight(child, extraHeight));
        }
        return actualHeight;
    }
}

