/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.designgridlayout;

import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;
import net.java.dev.designgridlayout.ComponentGapsHelper;
import net.java.dev.designgridlayout.HeightGrowPolicy;
import net.java.dev.designgridlayout.IExtractor;
import net.java.dev.designgridlayout.IRowItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ComponentHelper {
    private ComponentHelper() {
    }

    static int maxValues(Iterable<? extends IRowItem> items, IExtractor extractor) {
        int max = 0;
        for (IRowItem iRowItem : items) {
            max = Math.max(max, extractor.value(iRowItem));
        }
        return max;
    }

    static int sumValues(Iterable<? extends IRowItem> items, IExtractor extractor) {
        int sum = 0;
        for (IRowItem iRowItem : items) {
            sum += extractor.value(iRowItem);
        }
        return sum;
    }

    static int hgap(List<? extends IRowItem> items, Container parent) {
        return ComponentHelper.hgap(ComponentGapsHelper.instance(), items, parent);
    }

    static int hgap(JComponent first, List<? extends IRowItem> items, Container parent) {
        ComponentGapsHelper helper = ComponentGapsHelper.instance();
        int hgap = 0;
        if (first != null && !items.isEmpty()) {
            hgap = ComponentHelper.hgap(helper, first, items.get(0).component(), parent);
        }
        return Math.max(hgap, ComponentHelper.hgap(helper, items, parent));
    }

    static boolean isFixedHeight(HeightGrowPolicy policy, Iterable<? extends IRowItem> items) {
        for (IRowItem iRowItem : items) {
            if (!policy.canGrowHeight(iRowItem.component()) || !iRowItem.isLastSpanRow()) continue;
            return false;
        }
        return true;
    }

    private static int hgap(ComponentGapsHelper helper, List<? extends IRowItem> items, Container parent) {
        int hgap = 0;
        int size = items.size() - 1;
        for (int nth = 0; nth < size; ++nth) {
            JComponent left = items.get(nth).component();
            JComponent right = items.get(nth + 1).component();
            int gap = ComponentHelper.hgap(helper, left, right, parent);
            hgap = Math.max(hgap, gap);
        }
        return hgap;
    }

    private static int hgap(ComponentGapsHelper helper, JComponent left, JComponent right, Container parent) {
        return helper.getHorizontalGap(left, right, 0, parent);
    }
}

