/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util.os;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.ProcessExecutor;
import ru.softlogic.system.util.os.LinuxShellApi;
import ru.softlogic.system.util.os.OsException;
import ru.softlogic.system.util.os.ShellApi;
import ru.softlogic.system.util.os.WindowsShellApi;

public class OsApi {
    public static final int OK = 0;
    public static final int ERR_ACCESS_DENIED = 1;
    public static final int ERR_TIMEOUT = 2;
    public static final int ERR_ERROR = 3;
    private static volatile OsApi instance;
    private ProcessExecutor executor;
    private ShellApi shellApi;

    private OsApi() {
        if (SystemProp.getTerminalDir() == null) {
            throw new IllegalArgumentException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e terminal.dir");
        }
        String dir = SystemProp.getTerminalDir();
        switch (OsDetector.current()) {
            case 1: {
                this.shellApi = new LinuxShellApi(dir);
                break;
            }
            case 2: {
                this.shellApi = new WindowsShellApi(dir);
            }
        }
    }

    public void setExecutor(ProcessExecutor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OsApi getInstance() {
        if (instance != null) return instance;
        Class<OsApi> clazz = OsApi.class;
        synchronized (OsApi.class) {
            if (instance != null) return instance;
            instance = new OsApi();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void rebootModem(String params) throws OsException {
        try {
            this.executeProcess(this.shellApi.rebootModem(params));
        }
        catch (IOException ex) {
            throw new OsException(ex);
        }
    }

    public void initWatchdog(String params) throws OsException {
        try {
            this.executeProcess(this.shellApi.initWatchdog(params));
        }
        catch (IOException ex) {
            throw new OsException(ex);
        }
    }

    public void startVpn() throws OsException {
        try {
            this.executeProcess(this.shellApi.startVpn());
        }
        catch (IOException ex) {
            throw new OsException(ex);
        }
    }

    public void stopVpn() throws OsException {
        try {
            this.executeProcess(this.shellApi.stopVpn());
        }
        catch (IOException ex) {
            throw new OsException(ex);
        }
    }

    public void scheduleDiskCheck() throws OsException {
        try {
            this.executeProcess(this.shellApi.sheduleDiskCheck());
        }
        catch (IOException ex) {
            throw new OsException(ex);
        }
    }

    public void runExternal(int serviceId) throws OsException {
        try {
            this.executeProcess(this.shellApi.runExternal(serviceId));
        }
        catch (IOException ex) {
            throw new OsException(ex);
        }
    }

    public int setLocalTime(Date date) {
        Object obj = this.shellApi.setLocalTime(date);
        if (obj == null) {
            return 3;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        if (obj instanceof Process) {
            try {
                return this.executeProcess((Process)obj);
            }
            catch (OsException ex) {
                return 3;
            }
        }
        return 3;
    }

    public boolean setTimeZone(int timeZone) {
        return this.shellApi.setTimeZone(timeZone);
    }

    public void openControlPanel() throws OsException {
        try {
            this.executeProcess(this.shellApi.openContolPanel());
        }
        catch (IOException ex) {
            throw new OsException(ex);
        }
    }

    private int executeProcess(Process proc) throws OsException {
        if (proc != null && this.executor != null) {
            try {
                return this.executor.executeProcess(proc, 60);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return 2;
            }
            catch (ExecutionException | TimeoutException ex) {
                proc.destroy();
                throw new OsException(ex);
            }
        }
        return 3;
    }

    public void generatePrecessList() throws OsException {
        try {
            this.executeProcess(this.shellApi.generateProcessList());
        }
        catch (IOException ex) {
            throw new OsException(ex);
        }
    }

    public void openControlGSM() throws OsException {
        try {
            this.executeProcess(this.shellApi.openContolPanel());
        }
        catch (IOException ex) {
            throw new OsException(ex);
        }
    }

    public void startCMSetup(String login, String password) throws OsException {
        try {
            this.executeProcess(this.shellApi.startCMSetup(login, password));
        }
        catch (IOException ex) {
            throw new OsException(ex);
        }
    }

    public void runScript(String path, String[] params) throws OsException {
        if (path == null || path.trim().isEmpty()) {
            throw new OsException("Need path");
        }
        try {
            this.executeProcess(this.shellApi.runScript(path, params));
        }
        catch (IOException ex) {
            throw new OsException(ex);
        }
    }

    public void sharingNetwork(boolean enabled) throws OsException {
        try {
            this.shellApi.sharingNetwork(enabled);
        }
        catch (IOException ex) {
            throw new OsException(ex);
        }
    }
}

