/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util.os;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ru.softlogic.system.util.os.ShellApi;

public class LinuxShellApi
implements ShellApi {
    private String dir;

    LinuxShellApi(String dir) {
        if (dir == null || dir.isEmpty()) {
            throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438");
        }
        this.dir = dir;
    }

    @Override
    public Process startVpn() throws IOException {
        return Runtime.getRuntime().exec(this.dir + "/bin/script.sh start-vpn");
    }

    @Override
    public Process stopVpn() throws IOException {
        return Runtime.getRuntime().exec(this.dir + "/bin/script.sh stop-vpn");
    }

    @Override
    public Process rebootModem(String params) throws IOException {
        return Runtime.getRuntime().exec(this.dir + "/bin/script.sh reboot-modem " + params);
    }

    @Override
    public Process initWatchdog(String params) throws IOException {
        return Runtime.getRuntime().exec(this.dir + "/bin/script.sh init-watchdog " + params);
    }

    @Override
    public Object setLocalTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
        try {
            return Runtime.getRuntime().exec(this.dir + "/bin/script.sh set-time " + format.format(date));
        }
        catch (IOException ex) {
            return ex;
        }
    }

    @Override
    public boolean setTimeZone(int timeZone) {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"sudo", this.dir + "/bin/chmtu", "" + timeZone});
            return true;
        }
        catch (Throwable th) {
            return false;
        }
    }

    @Override
    public Process sheduleDiskCheck() throws IOException {
        return Runtime.getRuntime().exec(this.dir + "/bin/script.sh check-disk");
    }

    @Override
    public Process openContolPanel() throws IOException {
        return Runtime.getRuntime().exec(this.dir + "/bin/script.sh open-control-panel");
    }

    @Override
    public Process runExternal(int serviceId) throws IOException {
        return Runtime.getRuntime().exec(this.dir + "/bin/script.sh run-external " + serviceId);
    }

    @Override
    public Process generateProcessList() throws IOException {
        return Runtime.getRuntime().exec(this.dir + "/bin/script.sh process-list");
    }

    @Override
    public Process startCMSetup(String userId, String userlogin) throws IOException {
        return Runtime.getRuntime().exec(new String[]{this.dir + "/COFFEE_MACHINE/CMSetup", userId, userlogin});
    }

    @Override
    public Process openContolGSM() throws IOException {
        return Runtime.getRuntime().exec(this.dir + "/bin/script.sh open-control-gsm");
    }

    @Override
    public Process sharingNetwork(boolean enabled) throws IOException {
        return Runtime.getRuntime().exec(this.dir + "/bin/script.sh fiscalshare " + (enabled ? "enable" : "disable"));
    }

    @Override
    public Process runScript(String path, String[] params) throws IOException {
        String cmd = path;
        for (int i = 0; params != null && i < params.length; ++i) {
            if (params[i] == null || params[i].trim().isEmpty()) continue;
            cmd = cmd + " " + params[i];
        }
        return Runtime.getRuntime().exec(cmd);
    }
}

