/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util.network;

import ru.softlogic.app.configuration.SystemProp;

public class Ping {
    public static boolean isAlive(String host) {
        if (host == null || host.isEmpty()) {
            return false;
        }
        try {
            String cmdLine = null;
            String osName = SystemProp.getOSName();
            if (osName.equals("Linux")) {
                cmdLine = "ping -c 1 ";
            } else if (osName.toLowerCase().indexOf("windows") != -1) {
                cmdLine = "ping -n 1 ";
            }
            if (cmdLine != null) {
                Process p = Runtime.getRuntime().exec(cmdLine + host);
                int status = p.waitFor();
                return status == 0;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isNetworkAlive() {
        String[] hosts;
        for (String host : hosts = new String[]{"yandex.ru", "google.com", "rambler.ru"}) {
            if (!Ping.isAlive(host)) continue;
            return true;
        }
        return false;
    }
}

