/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util.display;

import java.io.IOException;
import ru.softlogic.system.util.display.DisplayManager;

public class LinuxDisplayManager
implements DisplayManager {
    @Override
    public int displayOff() {
        return LinuxDisplayManager.runCommand("off");
    }

    @Override
    public int displayOn() {
        return LinuxDisplayManager.runCommand("on");
    }

    private static int runCommand(String command) {
        if (!"off".equals(command) && !"on".equals(command)) {
            return -3;
        }
        try {
            Process proc = Runtime.getRuntime().exec("xset dpms force " + command);
            proc.waitFor();
            proc.destroy();
        }
        catch (IOException e) {
            return -1;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return -2;
        }
        return 0;
    }
}

