/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class ProcessExecutor {
    private final ExecutorService executor = Executors.newFixedThreadPool(3);
    private final Logger log = Logger.getLogger((String)"app");

    public ProcessExecutor() {
        this.log.info((Object)"Start process executor");
    }

    public int executeProcess(Process proc, int timeout) throws InterruptedException, ExecutionException, TimeoutException {
        if (proc == null) {
            throw new NullPointerException();
        }
        LocalProcessExecutor pe = new LocalProcessExecutor(proc);
        Future<Integer> ft = this.executor.submit(pe);
        return ft.get(timeout, TimeUnit.SECONDS);
    }

    public int executeProcess(String proc, int timeout) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        if (proc == null) {
            throw new NullPointerException();
        }
        return this.executeProcess(Runtime.getRuntime().exec(proc), timeout);
    }

    public int executeProcess(ProcessBuilder pb, int timeout) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        if (pb == null) {
            throw new NullPointerException();
        }
        return this.executeProcess(pb.start(), timeout);
    }

    private class LocalProcessExecutor
    implements Callable<Integer> {
        private Process process;

        public LocalProcessExecutor(Process process) {
            if (process == null) {
                throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Process");
            }
            this.process = process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() throws Exception {
            String str2;
            ProcessExecutor.this.log.info((Object)("=== Execute process " + this.process + " ==="));
            this.process.waitFor();
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                str2 = null;
                ProcessExecutor.this.log.error((Object)"===>>err====================");
                while ((str2 = br.readLine()) != null) {
                    ProcessExecutor.this.log.error((Object)str2);
                }
            }
            catch (IOException str2) {
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException str2) {}
                }
            }
            try {
                ProcessExecutor.this.log.error((Object)"===>>inp====================");
                br = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                str2 = null;
                while ((str2 = br.readLine()) != null) {
                    ProcessExecutor.this.log.error((Object)str2);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return this.process.exitValue();
        }
    }
}

