/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import org.kc7bfi.jflac.util.CRC8;

public class PinCodeGenerator {
    private static final SimpleDateFormat MONTH = new SimpleDateFormat("MM");
    private static final SimpleDateFormat YEAR = new SimpleDateFormat("yy");

    public static String generate() {
        Date d = new Date();
        Random r = new Random();
        String pin = String.format("%010d", Math.abs(r.nextInt()));
        pin = pin.substring(0, 3) + MONTH.format(d) + pin.substring(3, 6) + YEAR.format(d) + pin.substring(6);
        String mac = PinCodeGenerator.getMac(pin);
        pin = pin.substring(0, 5) + mac.substring(0, 1) + pin.substring(5, 10) + mac.substring(1) + pin.substring(10);
        return pin;
    }

    public static boolean validate(String data) {
        if (data == null) {
            return false;
        }
        if (data.length() == 12) {
            String pin = data.substring(0, 3) + data.substring(4, 7) + data.substring(8);
            String crc = data.substring(3, 4) + data.substring(7, 8);
            return crc.equals(PinCodeGenerator.getMac(pin));
        }
        if (data.length() == 16) {
            String pin = data.substring(0, 5) + data.substring(6, 11) + data.substring(12);
            String crc = data.substring(5, 6) + data.substring(11, 12);
            return crc.equals(PinCodeGenerator.getMac(pin));
        }
        return false;
    }

    private static String getMac(String pin) {
        return String.format("%02d", CRC8.calc((byte[])pin.getBytes(), (int)pin.getBytes().length) & 0x63);
    }
}

