/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import ru.softlogic.app.configuration.SystemProp;

public class PathUtils {
    public static final String CONF = "configuration.xml";
    public static final String APP_JNI = "/jni/";
    public static final String LOG = "/log/";

    public static String getAppDrive() {
        File file = new File(PathUtils.getAppHome());
        while (file.getParentFile() != null) {
            file = file.getParentFile();
        }
        return file.getPath().replace("\\", "");
    }

    public static String getAppHome() {
        String appHome = SystemProp.getAppHome();
        if (appHome == null || appHome.isEmpty()) {
            File file = new File(new PathUtils().getPath());
            return new File(file.getParent()).getParent();
        }
        return appHome;
    }

    private String getPath() {
        try {
            return URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            return this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        }
    }

    public static String getFirmwaresPath() {
        return PathUtils.getAppHome() + "/data/firmware";
    }

    public static File getFilePath(String path) {
        if (path == null) {
            throw new NullPointerException("Path is not set");
        }
        return new File(PathUtils.getAppHome(), path);
    }

    public static Collection<File> getFiles() {
        LinkedList<File> files = new LinkedList<File>();
        for (String f : SystemProp.getJavaClasspath().split(File.pathSeparator)) {
            if (f.endsWith("*")) {
                files.addAll(FileUtils.listFiles((File)PathUtils.getFilePath(f.substring(0, f.length() - 1)), null, (boolean)false));
                continue;
            }
            files.add(new File(f));
        }
        files.addAll(FileUtils.listFiles((File)PathUtils.getFilePath(APP_JNI), null, (boolean)true));
        Iterator it = files.iterator();
        while (it.hasNext()) {
            if (!((File)it.next()).isDirectory()) continue;
            it.remove();
        }
        return files;
    }

    public static String getPath(String path) {
        if (path == null) {
            throw new NullPointerException("Path is not set");
        }
        return new File(PathUtils.getAppHome(), path).getAbsolutePath();
    }
}

