/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class ObjectReadWriteStream {
    private RandomAccessFile file;

    public ObjectReadWriteStream(String fileName) throws FileNotFoundException {
        try {
            this.file = new RandomAccessFile(fileName, "rwd");
        }
        catch (FileNotFoundException e) {
            FileNotFoundException fex = new FileNotFoundException("Can't create file: " + fileName);
            fex.setStackTrace(e.getStackTrace());
            throw fex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeObject(Serializable object) throws IOException {
        this.file.setLength(0L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(baos);
            outputStream.writeObject(object);
            this.file.write(baos.toByteArray());
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Object readObject() throws IOException {
        ObjectInputStream inputStream = null;
        try {
            Object result;
            this.file.seek(0L);
            inputStream = new ObjectInputStream(new RandomInputStream());
            Object object = result = inputStream.readObject();
            return object;
        }
        catch (EOFException ex) {
            Object var3_6 = null;
            return var3_6;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void close() throws IOException {
        this.file.close();
    }

    private class RandomInputStream
    extends InputStream {
        private RandomInputStream() {
        }

        @Override
        public int read() throws IOException {
            return ObjectReadWriteStream.this.file.read();
        }
    }

    private class RandomOutputStream
    extends OutputStream {
        private RandomOutputStream() {
        }

        @Override
        public void write(int i) throws IOException {
            ObjectReadWriteStream.this.file.write(i);
        }
    }
}

