/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import ru.softlogic.system.util.PathUtils;

public class FontLoader {
    public static Font fromBasePath(String name) {
        try {
            return Font.createFont(0, new File(PathUtils.getAppHome() + File.separator + "fonts" + File.separator + File.separator + name));
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font fromBasePath(String name, int fontType) {
        InputStream is = null;
        try {
            is = new FileInputStream(PathUtils.getAppHome() + File.separator + "fonts" + File.separator + File.separator + name);
            Font font = Font.createFont(fontType, is);
            return font;
        }
        catch (Exception ex) {
            Font font = null;
            return font;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font fromJar(String fullPath) {
        InputStream is = null;
        try {
            is = ClassLoader.getSystemResourceAsStream(fullPath);
            Font font = Font.createFont(0, is);
            return font;
        }
        catch (Exception ex) {
            Font font = null;
            return font;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Font fromJar(String fullPath, int fontType) {
        InputStream is = null;
        try {
            is = ClassLoader.getSystemResourceAsStream(fullPath);
            Font font = Font.createFont(fontType, is);
            return font;
        }
        catch (Exception ex) {
            Font font = null;
            return font;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

