/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import ru.softlogic.system.util.FileUtilException;

public class FileUtil {
    public static File checkDir(String path) throws FileUtilException {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0443\u0442\u044c");
        }
        try {
            File file = new File(path);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new FileUtilException("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0435\u0439");
                }
                if (!file.canExecute()) {
                    throw new FileUtilException("\u0414\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0434\u043b\u044f \u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0430");
                }
                if (!file.canRead()) {
                    throw new FileUtilException("\u0414\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f");
                }
                if (!file.canWrite()) {
                    throw new FileUtilException("\u0414\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044f \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438");
                }
            } else if (!file.mkdirs()) {
                throw new FileUtilException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044e");
            }
            return file;
        }
        catch (Throwable ex) {
            throw new FileUtilException(ex);
        }
    }

    public static File checkFile(String path) throws FileUtilException {
        if (path == null) {
            throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0443\u0442\u044c");
        }
        try {
            File file = new File(path);
            if (file.exists()) {
                if (!file.isFile()) {
                    throw new FileUtilException("\u0423\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0444\u0430\u0439\u043b\u043e\u043c");
                }
                if (!file.canRead()) {
                    throw new FileUtilException("\u0424\u0430\u0439\u043b \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0434\u043b\u044f \u0447\u0442\u0435\u043d\u0438\u044f");
                }
                if (!file.canWrite()) {
                    throw new FileUtilException("\u0424\u0430\u0439\u043b \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0434\u043b\u044f \u0437\u0430\u043f\u0438\u0441\u0438");
                }
            } else {
                FileUtil.checkDir(file.getParent());
                if (!file.createNewFile()) {
                    throw new FileUtilException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0444\u0430\u0439\u043b");
                }
            }
            return file;
        }
        catch (Throwable ex) {
            throw new FileUtilException(ex);
        }
    }

    public static String readFile(File file) throws FileUtilException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            throw new FileUtilException(ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String readFile(File file, String encoding) throws FileUtilException {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception ex) {
            throw new FileUtilException(ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeFile(File file, String content) throws FileUtilException {
        FileUtil.checkFile(file.getAbsolutePath());
        BufferedWriter br = null;
        try {
            br = new BufferedWriter(new FileWriter(file));
            br.write(content, 0, content.length());
            br.flush();
        }
        catch (Exception ex) {
            throw new FileUtilException(ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void writeFile(File file, InputStream from) throws FileUtilException {
        FileUtil.checkFile(file.getAbsolutePath());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            int len = 0;
            while ((len = from.read(buf)) > -1) {
                fos.write(buf, 0, len);
            }
        }
        catch (Exception ex) {
            throw new FileUtilException(ex);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
            if (from != null) {
                try {
                    from.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean mkParentDirs(File file) throws FileUtilException {
        if (!file.getParentFile().exists()) {
            if (FileUtil.mkParentDirs(file.getParentFile())) {
                return file.getParentFile().mkdir();
            }
            throw new FileUtilException("\u041d\u0435 \u043c\u043e\u0433\u0443 \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u044e " + file.getParentFile().getAbsolutePath());
        }
        return true;
    }
}

