/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.sequence;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import ru.softlogic.sequence.Sequence;
import ru.softlogic.sequence.SequenceException;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;

public class SequenceManager {
    private static SequenceManager instance;
    private final Map<String, Sequence> sequences = new HashMap<String, Sequence>();
    private File sequenceDir;

    private SequenceManager() throws SequenceException {
    }

    public void createManager(String dir) throws SequenceException {
        try {
            this.sequenceDir = FileUtil.checkDir(dir);
        }
        catch (Exception ex) {
            throw new SequenceException(ex);
        }
    }

    public static int getValueQuietly(String name) {
        try {
            return SequenceManager.getInstance().getSequence(name).next();
        }
        catch (SequenceException ex) {
            return 0;
        }
    }

    public synchronized Sequence getSequence(String name) throws SequenceException {
        if (this.sequenceDir == null) {
            throw new SequenceException("Manager must be inited");
        }
        if (this.sequences.containsKey(name)) {
            return this.sequences.get(name);
        }
        FileSequence seq = new FileSequence(this.sequenceDir.getAbsolutePath() + File.separator + name);
        this.sequences.put(name, seq);
        return seq;
    }

    public static synchronized SequenceManager getInstance() throws SequenceException {
        if (instance == null) {
            instance = new SequenceManager();
        }
        return instance;
    }

    private class FileSequence
    implements Sequence {
        private File sequenceFile;
        private int value;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public FileSequence(String sequencePath) throws SequenceException {
            try {
                this.sequenceFile = FileUtil.checkFile(sequencePath);
            }
            catch (FileUtilException ex) {
                throw new SequenceException(ex);
            }
            this.value = 0;
            DataInputStream input = null;
            try {
                input = new DataInputStream(new FileInputStream(this.sequenceFile));
                this.value = input.readInt();
            }
            catch (IOException iOException) {
                IOUtils.closeQuietly(input);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)input);
        }

        @Override
        public synchronized int next() throws SequenceException {
            DataOutputStream output = null;
            try {
                output = new DataOutputStream(new FileOutputStream(this.sequenceFile));
                output.writeInt(this.value + 1);
            }
            catch (IOException ex) {
                try {
                    throw new SequenceException(ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(output);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)output);
            ++this.value;
            return this.value;
        }

        @Override
        public synchronized int current() {
            return this.value;
        }

        @Override
        public synchronized void setCurrent(int value) throws SequenceException {
            this.value = value;
            DataOutputStream output = null;
            try {
                output = new DataOutputStream(new FileOutputStream(this.sequenceFile));
                output.writeInt(value);
            }
            catch (IOException ex) {
                try {
                    throw new SequenceException(ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(output);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)output);
        }
    }
}

