/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.media;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.Player;
import org.apache.log4j.Logger;

public class MediaPlayer {
    private static final MediaPlayer instance = new MediaPlayer();
    private Player player;
    private final Logger log = Logger.getLogger((String)"sound");
    private final BlockingQueue<String> queue;
    private BlockingQueue<String> queueList;
    private String directory;
    private Thread thread;
    private Locale locale;

    private MediaPlayer() {
        this.log.setAdditivity(false);
        this.queue = new LinkedBlockingQueue<String>();
        this.queueList = new LinkedBlockingQueue<String>();
        this.thread = new Thread((Runnable)new PlayerThread(), "MediaPlayer");
        this.thread.setDaemon(true);
        this.thread.start();
        this.thread = new Thread((Runnable)new PlayerMangerThread(), "MediaPlayerManager");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public static MediaPlayer getInstance() {
        return instance;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public synchronized void play(String soundFile) {
        this.queue.add(soundFile);
    }

    private class PlayerMangerThread
    implements Runnable {
        private String lastFile;

        private PlayerMangerThread() {
        }

        @Override
        public void run() {
            MediaPlayer.this.log.debug((Object)"Start thread");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    String file = (String)MediaPlayer.this.queue.take();
                    Player lp = MediaPlayer.this.player;
                    if (!(lp == null || this.lastFile != null && this.lastFile.startsWith("_"))) {
                        lp.close();
                    }
                    MediaPlayer.this.queueList.add(file);
                    this.lastFile = file;
                }
                catch (InterruptedException ex) {
                    MediaPlayer.this.log.debug((Object)"\u0417\u0430\u0432\u0435\u0440\u0448\u0430\u044e \u043f\u043e\u0442\u043e\u043a");
                    Thread.currentThread().interrupt();
                }
                catch (Throwable ex) {
                    MediaPlayer.this.log.debug((Object)"\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u043b\u0435\u0439\u0435\u0440\u0430", ex);
                }
            }
            MediaPlayer.this.log.debug((Object)"Stop thread");
        }
    }

    private class PlayerThread
    implements Runnable {
        private PlayerThread() {
        }

        @Override
        public void run() {
            MediaPlayer.this.log.debug((Object)"Start thread");
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    String file = (String)MediaPlayer.this.queueList.take();
                    Player lp = MediaPlayer.this.player;
                    if (lp != null) {
                        lp.close();
                    }
                    if (MediaPlayer.this.directory == null) {
                        MediaPlayer.this.directory = "";
                    }
                    File soundFile = new File(MediaPlayer.this.directory + MediaPlayer.this.locale.getLanguage() + File.separator + file);
                    if (MediaPlayer.this.locale != null && soundFile.exists()) {
                        MediaPlayer.this.player = new Player((InputStream)new FileInputStream(soundFile));
                    } else {
                        MediaPlayer.this.player = new Player((InputStream)new FileInputStream(MediaPlayer.this.directory + file));
                    }
                    MediaPlayer.this.player.play();
                }
                catch (InterruptedException ex) {
                    MediaPlayer.this.log.debug((Object)"\u0417\u0430\u0432\u0435\u0440\u0448\u0430\u044e \u043f\u043e\u0442\u043e\u043a");
                    Thread.currentThread().interrupt();
                }
                catch (FileNotFoundException ex) {
                }
                catch (JavaLayerException ex) {
                    MediaPlayer.this.log.debug((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u043e\u0441\u043f\u0440\u043e\u0438\u0437\u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0430\u0439\u043b\u0430", (Throwable)ex);
                }
                catch (Throwable ex) {
                    MediaPlayer.this.log.debug((Object)"\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u0430\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u043b\u0435\u0439\u0435\u0440\u0430", ex);
                }
            }
            MediaPlayer.this.log.debug((Object)"Stop thread");
        }
    }
}

