/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.scanner.DeviceTypeFilter;
import ru.softlogic.system.util.PathUtils;

public class AppDefaults
implements DeviceTypeFilter {
    private static final AppDefaults instance = new AppDefaults();
    private final List<DeviceType> allowed;
    private final List<DeviceType> notAllowed;
    private List<String> tabs;
    private Properties defaults;
    private String[] minusPrefixes;
    private Locale logLocale = Locale.getDefault();
    private String[] printerEncoding;

    public AppDefaults() {
        this.defaults = new Properties();
        String paramsPath = PathUtils.getAppHome() + File.separator + "resources" + File.separator + "params.properties";
        try (FileInputStream fis2 = new FileInputStream(paramsPath);){
            this.defaults.load(new InputStreamReader((InputStream)fis2, "utf-8"));
        }
        catch (IOException fis2) {
            // empty catch block
        }
        this.allowed = this.getTypeList("hardware.allowed");
        this.notAllowed = this.getTypeList("hardware.notallowed");
        if (this.defaults.getProperty("tabs") != null) {
            String[] t = this.defaults.getProperty("tabs").split(",");
            this.tabs = Arrays.asList(t);
        }
        if (this.defaults.getProperty("balance.minus") != null) {
            this.minusPrefixes = this.defaults.getProperty("balance.minus").split(",");
        }
        if (this.defaults.getProperty("log.locale") != null && this.defaults.getProperty("log.locale").matches("^[a-z]{2}(_[A-Z]{2})?$")) {
            String[] tmp = this.defaults.getProperty("log.locale").split("_");
            this.logLocale = new Locale(tmp[0], tmp.length == 2 ? tmp[1] : "");
        }
        if (this.defaults.getProperty("printer.encoding") != null) {
            this.printerEncoding = this.defaults.getProperty("printer.encoding").split(",");
        }
    }

    public static AppDefaults getInstance() {
        return instance;
    }

    private List<DeviceType> getTypeList(String key) {
        LinkedList<DeviceType> result = null;
        String prop = this.defaults.getProperty(key);
        if (prop != null && !prop.isEmpty()) {
            result = new LinkedList<DeviceType>();
            for (String dts : prop.split(",|;| ")) {
                try {
                    result.add(DeviceType.valueOf((String)dts));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public boolean isDeviceAllowed(DeviceType dt) {
        if (dt == null) {
            return false;
        }
        if (this.notAllowed != null && this.notAllowed.contains(dt)) {
            return false;
        }
        if (this.allowed != null && this.allowed.size() > 0) {
            return this.allowed.contains(dt);
        }
        return true;
    }

    public Integer getIntegerValue(String key, int defaultValue) {
        Integer result = this.getIntegerValue(key);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    public Integer getIntegerValue(String key) {
        String p = this.defaults.getProperty(key);
        if (p != null && p.matches("\\d+")) {
            return Integer.parseInt(p);
        }
        return null;
    }

    public String getStringValue(String key, String defaultValue) {
        String result = this.defaults.getProperty(key);
        if (result != null) {
            return result;
        }
        return defaultValue;
    }

    public String getStringValue(String key) {
        return this.defaults.getProperty(key);
    }

    public int getPosPrinterLeftMargin() {
        return this.getIntegerValue("posprinter.left-margin", 0);
    }

    public int getPosPrinterScroll() {
        return this.getIntegerValue("posprinter.scroll", 4);
    }

    public int getPosPrinterPrintWidth() {
        return this.getIntegerValue("posprinter.width", 57);
    }

    public int getPosPrinterSpan() {
        return this.getIntegerValue("posprinter.span", 0);
    }

    public int getPosPrinterFontSize() {
        return this.getIntegerValue("posprinter.font-size", 0);
    }

    public boolean isSuppressImplictConfirm() {
        return this.getBooleanProperty("suppress_implict_confirm", false);
    }

    public String[] getMinusPrefixes() {
        return this.minusPrefixes;
    }

    public String getProperty(String key, String defaultValue) {
        return this.defaults.getProperty(key, defaultValue);
    }

    public String getProperty(String key) {
        return this.defaults.getProperty(key);
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.defaults.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public Locale getLogLocale() {
        return this.logLocale;
    }

    public String[] getPrinterEncoding() {
        return this.printerEncoding;
    }

    public boolean isActiveTab(String name) {
        if (this.tabs == null || this.tabs.isEmpty()) {
            return true;
        }
        return this.tabs.contains(name);
    }

    public boolean isActiveTabDefined(String name) {
        if (this.tabs == null || this.tabs.isEmpty()) {
            return false;
        }
        return this.tabs.contains(name);
    }
}

