/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.updater;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import ru.softlogic.update.updater.ItemProgressListener;
import ru.softlogic.update.updater.ListInfo;
import ru.softlogic.update.updater.ProgressListener;
import ru.softlogic.update.updater.UpdateControl;
import ru.softlogic.update.updater.UpdateItem;
import ru.softlogic.update.updater.UpdateSize;
import ru.softlogic.update.updater.UpdateStore;
import ru.softlogic.update.updater.exceptions.ChangeStoreException;
import ru.softlogic.update.updater.exceptions.CorruptedFileException;
import ru.softlogic.update.updater.exceptions.InvalidStoreException;
import ru.softlogic.update.updater.exceptions.RemoteFileNotFoundException;

class Updater {
    private UpdateStore us;
    private File appDir;
    private File updateDir;
    private Logger log;
    private ListInfo listInfo;

    public Updater(UpdateStore us, File appDir, File updateDir) {
        if (us == null) {
            throw new NullPointerException("UpdateStore");
        }
        if (appDir == null) {
            throw new NullPointerException("AppDir");
        }
        if (updateDir == null) {
            throw new NullPointerException("UpdateDir");
        }
        this.us = us;
        this.appDir = appDir;
        this.updateDir = updateDir;
        this.log = Logger.getLogger((String)"update");
    }

    public UpdateSize getUpdateSize() throws IOException, RemoteFileNotFoundException, InvalidStoreException, CorruptedFileException {
        this.checkEnviroment();
        if (this.isNeedListUpdate()) {
            this.log.info((Object)"Needs to update list.xml");
            this.downloadList();
        } else {
            this.log.info((Object)"Update list.xml is not needed");
        }
        List<UpdateItem> items = this.getRequireUpdate(this.getItemsList());
        if (items.size() > 0) {
            int size = 0;
            LinkedList<String> files = new LinkedList<String>();
            for (UpdateItem ui : items) {
                size += ui.getSize();
                files.add(ui.getFilename());
            }
            return new UpdateSize(size, items.size(), files);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(List<String> files, ProgressListener listener, UpdateControl updateControl) throws CorruptedFileException, IOException, RemoteFileNotFoundException, InvalidStoreException, ChangeStoreException {
        if (updateControl == null) {
            throw new NullPointerException("UpdateControl");
        }
        this.checkEnviroment();
        this.log.info((Object)"Start download");
        List<UpdateItem> items = this.getRequireUpdate(this.getItemsList(), files);
        if (items.size() > 0) {
            this.log.debug((Object)("Required items: " + items));
            long begin = System.currentTimeMillis();
            int size = 0;
            for (int i = 0; i < items.size(); ++i) {
                size += items.get(i).getSize();
            }
            int downloaded = 0;
            for (int i = 0; i < items.size(); ++i) {
                UpdateItem ui = items.get(i);
                listener.onProgress(ui.getFilename(), size, downloaded);
                File dest = new File(this.updateDir, ui.getFilename());
                File destDir = dest.getParentFile();
                if (!destDir.exists()) {
                    destDir.mkdirs();
                }
                this.log.info((Object)("Start " + String.format("%2d", i + 1) + "/" + items.size() + " " + ui + "->" + dest));
                boolean success = false;
                for (int z = 0; z <= 15 && !success; ++z) {
                    try {
                        for (int j = 0; j < 2; ++j) {
                            this.us.download(ui, dest, new ItemProgressListener(listener, size, downloaded), "" + (i + 1) + "/" + items.size());
                            if (ui.getCrc() == Updater.calculateChecksum(dest).longValue()) break;
                            this.log.info((Object)"Crc is corrupted, check list.xml changes");
                            ListInfo curr = this.us.getListInfo();
                            if (!curr.equals(this.listInfo)) {
                                throw new ChangeStoreException("list.xml was changed on server. Needs to restart the update process");
                            }
                            if (j != 0) {
                                throw new CorruptedFileException("Crc " + dest.getAbsolutePath() + " is not correct");
                            }
                            dest.delete();
                        }
                        this.log.info((Object)"Downloaded!");
                        success = true;
                        continue;
                    }
                    catch (IOException ex) {
                        this.log.error((Object)ex, (Throwable)ex);
                        if (z < 20 && updateControl.confirmRetry(z, ex)) {
                            this.log.error((Object)"Sleep 10 seconds");
                            try {
                                Thread.sleep(z * 5 * 1000);
                                continue;
                            }
                            catch (InterruptedException ex1) {
                                Thread.currentThread().interrupt();
                                throw new IOException(ex);
                            }
                        }
                        throw ex;
                    }
                    finally {
                        dest.setLastModified(ui.getMtime());
                    }
                }
                listener.onProgress(ui.getFilename(), size, downloaded += ui.getSize());
            }
        } else {
            this.log.info((Object)"Nothing todo");
        }
    }

    public List<UpdateItem> getRequireUpdate(List<UpdateItem> avaliable) {
        if (avaliable == null) {
            throw new NullPointerException("List<UpdateItem>");
        }
        this.log.info((Object)"Check files crc");
        LinkedList<UpdateItem> result = new LinkedList<UpdateItem>();
        for (UpdateItem ui : avaliable) {
            File updFile = new File(this.updateDir, ui.getFilename());
            if (updFile.exists()) {
                Long updfCrc = Updater.calculateChecksum(updFile);
                if (updfCrc != null && ui.getCrc() == updfCrc.longValue()) continue;
                result.add(ui);
                continue;
            }
            File mainFile = new File(this.appDir, ui.getFilename());
            Long mainfCrc = Updater.calculateChecksum(mainFile);
            if (mainFile.exists() && mainfCrc != null && ui.getCrc() == mainfCrc.longValue()) continue;
            result.add(ui);
        }
        this.log.info((Object)"Check comlete");
        return result;
    }

    public List<UpdateItem> getRequireUpdate(List<UpdateItem> avaliable, List<String> required) {
        if (avaliable == null) {
            throw new NullPointerException("List<UpdateItem>");
        }
        LinkedList<UpdateItem> result = new LinkedList<UpdateItem>();
        for (UpdateItem ui : avaliable) {
            if (!required.contains(ui.getFilename())) continue;
            result.add(ui);
        }
        return result;
    }

    private List<UpdateItem> getItemsList() throws CorruptedFileException {
        LinkedList<UpdateItem> result = new LinkedList<UpdateItem>();
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(new File(this.updateDir, "list.xml"));
            Element root = document.getRootElement();
            int totalSize = 0;
            for (Object obj : root.elements()) {
                Element element = (Element)obj;
                String fileName = element.attributeValue("name");
                long crc = Long.parseLong(element.attributeValue("crc"));
                int size = Integer.parseInt(element.attributeValue("size"));
                long mtime = Long.parseLong(element.attributeValue("mtime"));
                result.add(new UpdateItem(fileName, crc, size, mtime));
                totalSize += size;
            }
            return result;
        }
        catch (DocumentException ex) {
            throw new CorruptedFileException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadList() throws IOException, RemoteFileNotFoundException, InvalidStoreException, CorruptedFileException {
        this.log.info((Object)"Download update items list");
        if (this.listInfo == null) {
            this.log.info((Object)"Get list info");
            this.listInfo = this.us.getListInfo();
        }
        File list = new File(this.updateDir, "list.xml");
        long localCrc = 0L;
        for (int i = 0; i < 2; ++i) {
            this.log.info((Object)("attempt " + (i + 1)));
            UpdateItem ui = new UpdateItem("list.xml", this.listInfo.getCrc(), this.listInfo.getSize(), this.listInfo.getMtime());
            try {
                this.us.download(ui, list, null, null);
            }
            finally {
                list.setLastModified(ui.getMtime());
            }
            this.log.info((Object)"Downloaded");
            localCrc = Updater.calculateChecksum(list);
            this.log.info((Object)("Local crc=" + localCrc + ", remote crc=" + this.listInfo.getCrc()));
            if (localCrc != this.listInfo.getCrc()) {
                this.log.info((Object)"Try to refresh remote crc");
                this.listInfo = this.us.getListInfo();
                this.log.info((Object)("Success, remote crc=" + this.listInfo.getCrc()));
            }
            if (localCrc == this.listInfo.getCrc()) {
                return;
            }
            this.log.info((Object)"Crc not correct, try one more");
            list.delete();
        }
        throw new CorruptedFileException("Crc list.xm is not correct, local crc=" + localCrc + ", remote crc=" + this.listInfo.getCrc());
    }

    private void checkEnviroment() throws InvalidStoreException {
        if (!this.appDir.exists()) {
            throw new InvalidStoreException("Application dir not exist");
        }
        if (!this.appDir.isDirectory()) {
            throw new InvalidStoreException("Application dir is not directory");
        }
        if (!this.updateDir.exists()) {
            if (!this.updateDir.mkdirs()) {
                throw new InvalidStoreException("Can' create update folder");
            }
        } else if (!this.updateDir.isDirectory()) {
            throw new InvalidStoreException("Update dir is not directory");
        }
        if (this.updateDir.getFreeSpace() < 0x3200000L) {
            throw new InvalidStoreException("Disk has no free space. Exit");
        }
    }

    private boolean isNeedListUpdate() throws IOException, RemoteFileNotFoundException {
        this.log.info((Object)"Check for updates");
        File list = new File(this.updateDir, "list.xml");
        if (!list.exists()) {
            return true;
        }
        Long localCrc = Updater.calculateChecksum(list);
        if (localCrc == null) {
            return true;
        }
        this.listInfo = this.us.getListInfo();
        return localCrc.longValue() != this.listInfo.getCrc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long calculateChecksum(File file) {
        FileInputStream fis = null;
        try {
            CRC32 cs = new CRC32();
            cs.reset();
            fis = new FileInputStream(file);
            byte[] buf = new byte[1024];
            int l = 0;
            while ((l = fis.read(buf)) >= 0) {
                cs.update(buf, 0, l);
            }
            Long l2 = cs.getValue();
            return l2;
        }
        catch (Exception ex) {
            Long l = null;
            return l;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

