/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.updater;

import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.update.updater.ProgressListener;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateLocks;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateRequest;
import ru.softlogic.update.updater.UpdateSize;
import ru.softlogic.update.updater.Updater;
import ru.softlogic.update.updater.exceptions.ChangeStoreException;
import ru.softlogic.update.updater.exceptions.UpdateException;

public class UpdateHandler
implements Runnable {
    private UpdateRequest request;
    private Logger log;
    private StateListener system;
    private StateListener client;

    public UpdateHandler(StateListener system) {
        this.system = system;
        this.log = Logger.getLogger((String)"update");
        this.log.setAdditivity(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUpdateRequest(UpdateRequest updateRequest) {
        UpdateHandler updateHandler = this;
        synchronized (updateHandler) {
            if (updateRequest != null && this.request == null) {
                this.request = updateRequest;
                this.notifyAll();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                UpdateHandler updateHandler = this;
                synchronized (updateHandler) {
                    this.wait();
                }
                this.client = this.request.getStateListener();
                this.log.info((Object)("Get update request, url: " + this.request.getUpdateStore().getUrl()));
                Updater updater = new Updater(this.request.getUpdateStore(), this.request.getAppDir(), this.request.getUpdateDir());
                UpdateLocks.getInstance().setSoftwareLocked(true);
                try {
                    boolean success = false;
                    for (int j = 0; j < 2; ++j) {
                        try {
                            this.notifyStart();
                            UpdateSize updateSize = updater.getUpdateSize();
                            if (updateSize == null) {
                                this.log.info((Object)"Nothing todo");
                                this.notifySkip();
                            } else if (this.request.getUpdateControl().confirmUpdate(updateSize.getSize())) {
                                this.log.info((Object)"Update confirmed");
                                this.notifyConfirm(updateSize);
                                long start = System.currentTimeMillis();
                                updater.process(updateSize.getFiles(), new LocalProgressListener(this.client), this.request.getUpdateControl());
                                long timeout = System.currentTimeMillis() - start;
                                if (timeout > 0L) {
                                    this.log.info((Object)("Download time: " + String.format("%.2f", (double)timeout * 1.0 / 1000.0) + " s"));
                                    this.log.info((Object)("Average speed: " + String.format("%.2f", (double)updateSize.getSize() * 1.0 / 1024.0 * 1000.0 / (double)timeout) + " kBps"));
                                }
                                this.notifySuccess(new UpdateMetric(updateSize.getSize(), updateSize.getCount(), timeout));
                            } else {
                                this.log.info((Object)"Update not confirmed");
                                this.notifyCancel();
                            }
                            success = true;
                            break;
                        }
                        catch (ChangeStoreException ex) {
                            this.log.info((Object)"Needs to restart process", (Throwable)ex);
                            continue;
                        }
                    }
                    if (!success) {
                        throw new UpdateException(true, "Volative store");
                    }
                    this.log.info((Object)"Update successfully finished");
                    UpdateLocks.getInstance().setSoftwareLocked(false);
                }
                catch (UpdateException ex) {
                    this.log.error((Object)"An error occurred when updating: ", (Throwable)ex);
                    if (ex.isGlobalError()) {
                        this.notifyGlobalError(ex);
                    } else {
                        this.notifyLocalError(ex, null);
                    }
                }
                catch (IOException ex) {
                    this.log.error((Object)"An error occurred when updating: ", (Throwable)ex);
                    this.notifyLocalError(ex, null);
                }
                this.request = null;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.log.info((Object)"Stop thread");
    }

    private void notifyStart() {
        if (this.system != null) {
            this.system.onStart();
        }
        this.client.onStart();
    }

    private void notifySkip() {
        if (this.system != null) {
            this.system.onSkip();
        }
        this.client.onSkip();
    }

    private void notifyCancel() {
        if (this.system != null) {
            this.system.onCancel();
        }
        this.client.onCancel();
    }

    private void notifySuccess(UpdateMetric um) {
        if (this.system != null) {
            this.system.onSuccess(um);
        }
        this.client.onSuccess(um);
    }

    private void notifyConfirm(UpdateSize size) {
        if (this.system != null) {
            this.system.onConfirm(size);
        }
        this.client.onConfirm(size);
    }

    private void notifyGlobalError(Exception ex) {
        if (this.system != null) {
            this.system.onGlobalError(ex);
        }
        this.client.onGlobalError(ex);
    }

    private void notifyLocalError(Exception ex, UpdateMetric metric) {
        if (this.system != null) {
            this.system.onLocalError(ex, metric);
        }
        this.client.onLocalError(ex, metric);
    }

    private class LocalProgressListener
    implements ProgressListener {
        private StateListener stateListener;

        public LocalProgressListener(StateListener stateListener) {
            this.stateListener = stateListener;
        }

        @Override
        public void onProgress(String title, int total, int progress) {
            this.stateListener.onProgress(title, total, progress);
        }
    }
}

