/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.updater;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import ru.softlogic.update.updater.ListInfo;
import ru.softlogic.update.updater.ProgressListener;
import ru.softlogic.update.updater.SocketFactory;
import ru.softlogic.update.updater.UpdateItem;
import ru.softlogic.update.updater.UpdateStore;
import ru.softlogic.update.updater.exceptions.CreateStoreException;
import ru.softlogic.update.updater.exceptions.InvalidStoreException;
import ru.softlogic.update.updater.exceptions.RemoteFileNotFoundException;

public class HttpUpdateStore
implements UpdateStore {
    private String url;
    private int point;
    private CloseableHttpClient client;
    private Random rnd = new Random();
    private Logger log;

    public HttpUpdateStore(String url, int point) throws CreateStoreException {
        this(url, null, null, point, null);
    }

    public HttpUpdateStore(String url, String login, String password, int point, Integer timeout) throws CreateStoreException {
        if (url == null) {
            throw new CreateStoreException("Url not specify");
        }
        if (point < 0) {
            throw new CreateStoreException("Point must be positive");
        }
        this.url = (url + "/").replaceAll("([^:])//", "$1/");
        this.point = point;
        try {
            URL u = new URL(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout == null ? 120000 : timeout).setSocketTimeout(timeout == null ? 120000 : timeout).build();
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)SocketFactory.getFactory()).build();
            BasicHttpClientConnectionManager clientConnectionManager = new BasicHttpClientConnectionManager((Lookup)registry);
            HttpClientBuilder clientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)clientConnectionManager).setUserAgent("Soft-logic updater/2.3.1").setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(5, false)).setRedirectStrategy((RedirectStrategy)LaxRedirectStrategy.INSTANCE);
            int port = u.getPort();
            if (port < 0) {
                port = u.getDefaultPort();
            }
            if (login != null && password != null) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(u.getHost(), port), (Credentials)new UsernamePasswordCredentials(login, password));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            this.client = clientBuilder.build();
        }
        catch (Exception ex) {
            throw new CreateStoreException(ex);
        }
        this.log = Logger.getLogger((String)"update");
        this.log.setAdditivity(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(UpdateItem item, File dest, ProgressListener listener, String addInfo) throws IOException, RemoteFileNotFoundException, InvalidStoreException {
        if (dest == null) {
            throw new NullPointerException();
        }
        long rangeBegin = 0L;
        if (dest.exists()) {
            if (!dest.canWrite()) {
                throw new IOException("Can't write dest file: " + dest.getAbsolutePath());
            }
            if (dest.lastModified() == item.getMtime()) {
                rangeBegin = dest.length();
            }
        } else {
            try {
                if (!dest.createNewFile()) {
                    throw new IOException("Can't create new file: " + dest.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                throw new InvalidStoreException("Can't create new file: " + dest.getAbsolutePath(), (Throwable)ex);
            }
        }
        if (rangeBegin > 0L) {
            this.log.info((Object)("range begin=" + rangeBegin));
        }
        HttpPost post = new HttpPost(this.url + item.getFilename().replace(" ", "%20") + "?rnd=" + this.rnd.nextInt(10000000));
        post.addHeader((Header)new BasicHeader("X-PayLogic-Update", "Pay-logic " + this.point));
        if (addInfo != null && !addInfo.isEmpty()) {
            post.addHeader((Header)new BasicHeader("X-PayLogic-Progress", addInfo));
        }
        if (rangeBegin > 0L) {
            post.addHeader((Header)new BasicHeader("Range", "bytes=" + rangeBegin + "-"));
        }
        if (!dest.getName().matches(".*\\.xml$|.*\\.js$|.*\\.sh$|.*\\.properties$")) {
            post.addHeader((Header)new BasicHeader("Accept-Encoding", "identity"));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)post);
        this.log.debug((Object)("Response headers: " + Arrays.toString(response.getAllHeaders())));
        boolean canPartialContent = true;
        Header contentEncoding = response.getFirstHeader("Content-encoding");
        if (contentEncoding != null && !"identity".equals(contentEncoding.getValue())) {
            canPartialContent = false;
        }
        int resultCode = response.getStatusLine().getStatusCode();
        this.log.debug((Object)("Response status code: " + resultCode));
        if (resultCode == 404) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            throw new RemoteFileNotFoundException(item.getFilename());
        }
        if (resultCode == 416) {
            this.log.error((Object)("Get code: " + resultCode + ", delete file: " + dest.delete()));
            throw new IOException("Error " + response.getStatusLine().getStatusCode() + ", " + response.getStatusLine().getReasonPhrase());
        }
        if (resultCode != 200 && (resultCode != 206 || rangeBegin <= 0L)) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            throw new IOException("Error " + response.getStatusLine().getStatusCode() + ", " + response.getStatusLine().getReasonPhrase());
        }
        if (resultCode == 200) {
            rangeBegin = 0L;
        }
        HttpEntity entity = response.getEntity();
        int total = 0;
        if (entity != null) {
            InputStream is = entity.getContent();
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(dest, rangeBegin > 0L);
                byte[] buf = new byte[10000];
                int len = 0;
                while ((len = is.read(buf)) >= 0) {
                    fos.write(buf, 0, len);
                    total += len;
                    if (listener == null) continue;
                    listener.onProgress(item.getFilename(), item.getSize(), total);
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!canPartialContent && item.getSize() > total) {
            this.log.error((Object)("Partial content for compressed files is not supported, delete file: " + dest.delete()));
            throw new IOException("Partial content for compressed files is not supported");
        }
    }

    @Override
    public ListInfo getListInfo() throws IOException, RemoteFileNotFoundException {
        HttpPost post = new HttpPost(this.url + "list.crc");
        post.addHeader((Header)new BasicHeader("X-PayLogic-Update", "Pay-logic " + this.point));
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)post);
        if (response.getStatusLine().getStatusCode() == 404) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            throw new RemoteFileNotFoundException(response.getStatusLine().toString());
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            throw new IOException("Http error " + response.getStatusLine().getStatusCode());
        }
        String remoteData = EntityUtils.toString((HttpEntity)response.getEntity());
        if (remoteData == null || remoteData.isEmpty() || !remoteData.matches("^(\\d+) (\\d+) (\\d+)$")) {
            throw new IOException("Data not correct");
        }
        String[] dt = remoteData.split(" ");
        return new ListInfo(Long.parseLong(dt[0]), Integer.parseInt(dt[1]), Long.parseLong(dt[2]));
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

