/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.updater;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import ru.softlogic.update.updater.ListInfo;
import ru.softlogic.update.updater.ProgressListener;
import ru.softlogic.update.updater.UpdateItem;
import ru.softlogic.update.updater.UpdateStore;
import ru.softlogic.update.updater.exceptions.InvalidStoreException;
import ru.softlogic.update.updater.exceptions.RemoteFileNotFoundException;

public class FileUpdateStore
implements UpdateStore {
    private File path;

    public FileUpdateStore(File path) {
        if (path == null) {
            throw new NullPointerException("Path");
        }
        this.path = path;
    }

    @Override
    public String getUrl() {
        return this.path.getAbsolutePath();
    }

    @Override
    public ListInfo getListInfo() throws IOException, RemoteFileNotFoundException {
        String content = FileUtils.readFileToString((File)new File(this.path, "list.crc"));
        if (content == null || content.isEmpty() || !content.matches("^(\\d+) (\\d+) (\\d+)$")) {
            throw new IOException("Data not correct");
        }
        String[] dt = content.split(" ");
        return new ListInfo(Long.parseLong(dt[0]), Integer.parseInt(dt[1]), Long.parseLong(dt[2]));
    }

    @Override
    public void download(UpdateItem item, File dest, ProgressListener listener, String addInfo) throws IOException, RemoteFileNotFoundException, InvalidStoreException {
        if (item == null) {
            throw new NullPointerException("UpdateItem");
        }
        if (dest == null) {
            throw new NullPointerException("Dest");
        }
        FileUtils.copyFile((File)new File(this.path, item.getFilename()), (File)dest);
    }

    @Override
    public void close() {
    }
}

