/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.postproc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.log4j.Logger;
import ru.softlogic.update.postproc.FileProcessor;

public class TarDecompressor
implements FileProcessor {
    private static Logger log = Logger.getLogger((String)"start");
    private byte[] buffer = new byte[5000];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(File f) throws IOException {
        log.info((Object)("    " + f));
        String srcPath = f.getParent();
        FileInputStream fin = null;
        BufferedInputStream in = null;
        TarArchiveInputStream gzIn = null;
        boolean success = false;
        try {
            fin = new FileInputStream(f);
            in = new BufferedInputStream(fin);
            gzIn = new TarArchiveInputStream((InputStream)in);
            TarArchiveEntry tae = null;
            while ((tae = gzIn.getNextTarEntry()) != null) {
                log.info((Object)("        ->" + tae.getName() + ", size=" + tae.getSize()));
                if (tae.getSize() == 0L) {
                    File dir = new File(srcPath, tae.getName());
                    dir.mkdirs();
                    continue;
                }
                File nf = new File(srcPath, tae.getName());
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(nf);
                    int n = 0;
                    while (-1 != (n = gzIn.read(this.buffer))) {
                        out.write(this.buffer, 0, n);
                    }
                }
                finally {
                    if (out == null) continue;
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            log.info((Object)"        Uncompress successfully finished");
            success = true;
        }
        catch (Exception ex) {
            throw new IOException("An error occurred while uncompressing file: " + f, ex);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (gzIn != null) {
                try {
                    gzIn.close();
                }
                catch (Exception exception) {}
            }
        }
        if (success) {
            if (f.delete()) {
                log.info((Object)"        Tar archive successfully removed");
            } else {
                log.info((Object)"        An error occurred while removing the tar archive");
            }
        }
    }
}

