/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.postproc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class Maintenance {
    private static final Logger log = Logger.getLogger((String)"update");
    public static final String ACTION_REMOVE = "rm";
    public static final String ACTION_REMOVE_UPDATE = "rmu";
    public static final String ACTION_MOVE = "mv";

    public boolean serve(File appDir, File updateDir) {
        boolean success = true;
        log.info((Object)"Start software maintenance");
        try {
            List lines = FileUtils.readLines((File)new File(updateDir, "maintenance.rules"));
            if (lines.size() > 0) {
                for (String line : lines) {
                    log.debug((Object)("Process rule: " + line));
                    String[] rule = line.trim().split(" ");
                    if (rule.length == 2) {
                        if (ACTION_REMOVE.equals(rule[0])) {
                            success &= this.deleteFile(new File(appDir, rule[1]));
                            continue;
                        }
                        if (ACTION_REMOVE_UPDATE.equals(rule[0])) {
                            success &= this.deleteFile(new File(appDir, rule[1]));
                            this.deleteFile(new File(updateDir, rule[1]));
                            continue;
                        }
                        log.error((Object)("Unknown action: " + rule[0] + ", skip"));
                        continue;
                    }
                    log.info((Object)"Rule not correct");
                }
            } else {
                log.info((Object)"Noting to do");
            }
        }
        catch (IOException ex) {
            log.info((Object)"Maintenance rules not found");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean deleteFile(File file) {
        log.debug((Object)("    Try to remove file: " + file.getAbsolutePath()));
        if (file.exists()) {
            if (file.delete()) {
                log.debug((Object)"    File deleted");
                return true;
            }
            log.error((Object)"Error on delete file, reset file & set flag 'delete on exit'");
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            file.deleteOnExit();
            return false;
        }
        log.debug((Object)("    File not exist: " + file.getAbsolutePath()));
        return true;
    }
}

