/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.postproc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.log4j.Logger;
import ru.softlogic.update.postproc.FileProcessor;

public class GZipDecompressor
implements FileProcessor {
    private static Logger log = Logger.getLogger((String)"start");
    private byte[] buffer = new byte[5000];

    @Override
    public void process(File f) throws IOException {
        FileInputStream fin = null;
        BufferedInputStream in = null;
        FileOutputStream out = null;
        GzipCompressorInputStream gzIn = null;
        boolean success = false;
        try {
            String srcPath = f.getAbsolutePath();
            fin = new FileInputStream(srcPath);
            in = new BufferedInputStream(fin);
            String dstPath = srcPath.substring(0, srcPath.length() - ".gz".length());
            log.info((Object)("    " + f + "->" + dstPath));
            out = new FileOutputStream(dstPath);
            gzIn = new GzipCompressorInputStream((InputStream)in);
            int n = 0;
            while (-1 != (n = gzIn.read(this.buffer))) {
                out.write(this.buffer, 0, n);
            }
            log.info((Object)"        Uncompress successfully finished");
            success = true;
        }
        catch (Exception ex) {
            throw new IOException("An error occurred while uncompressing file: " + f, ex);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception exception) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            if (gzIn != null) {
                try {
                    gzIn.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

