/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.postproc;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.log4j.Logger;
import ru.softlogic.update.postproc.BZipDecompressor;
import ru.softlogic.update.postproc.GZipDecompressor;
import ru.softlogic.update.postproc.SearchTypesWalker;
import ru.softlogic.update.postproc.TarDecompressor;

public class Decompressor {
    private static final Logger log = Logger.getLogger((String)"update");

    public static void process(File appDir) {
        LinkedList<File> files;
        log.info((Object)"Start decompress files");
        IOFileFilter arcFilter = FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".gz"), FileFilterUtils.suffixFileFilter((String)".bz2")}));
        IOFileFilter tarFilter = FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".tar"));
        IOFileFilter df = FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.makeDirectoryOnly((IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.nameFileFilter((String)"img"), FileFilterUtils.nameFileFilter((String)"update"), FileFilterUtils.nameFileFilter((String)"log")})));
        log.info((Object)"Search 'gz' and 'bz2' files");
        SearchTypesWalker stw = new SearchTypesWalker(df, arcFilter);
        try {
            files = stw.getFiles(appDir);
            if (files != null && !files.isEmpty()) {
                GZipDecompressor gzd = new GZipDecompressor();
                BZipDecompressor bzd = new BZipDecompressor();
                for (File f : files) {
                    try {
                        if (f.getAbsolutePath().endsWith(".gz")) {
                            gzd.process(f);
                            continue;
                        }
                        if (!f.getAbsolutePath().endsWith(".bz2")) continue;
                        bzd.process(f);
                    }
                    catch (Exception ex) {
                        log.error((Object)("Error while decompressing: " + ex.getMessage()));
                    }
                }
            } else {
                log.info((Object)"Nothing todo");
            }
        }
        catch (IOException ex) {
            log.error((Object)("Error while serching: " + ex.getMessage()));
        }
        log.info((Object)"Search 'tar' files");
        stw = new SearchTypesWalker(df, tarFilter);
        try {
            files = stw.getFiles(appDir);
            if (files != null && !files.isEmpty()) {
                TarDecompressor td = new TarDecompressor();
                for (File f : files) {
                    try {
                        td.process(f);
                    }
                    catch (Exception ex) {
                        log.error((Object)("Error while decompressing: " + ex.getMessage()));
                    }
                }
            }
        }
        catch (IOException ex) {
            log.error((Object)("Error while serching: " + ex.getMessage()));
        }
    }
}

