/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.ppp;

import java.io.UnsupportedEncodingException;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.OperationResult;

class WindowsConnectionManager
implements ConnectionManager {
    private int lastError;
    private String lastErrorMessage;
    private boolean error;

    WindowsConnectionManager() {
    }

    @Override
    public synchronized String[] getConnectionsList() {
        this.init();
        byte[][] result = this.getConnectionsListNative();
        if (result == null) {
            return null;
        }
        String[] res = new String[result.length];
        for (int i = 0; i < result.length; ++i) {
            try {
                res[i] = new String(result[i], "cp1251");
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                res[i] = new String(result[i]);
            }
        }
        return res;
    }

    @Override
    public synchronized String[] getActiveConnectionsList() {
        this.init();
        byte[][] result = this.getActiveConnectionsListNative();
        if (result == null) {
            return null;
        }
        String[] res = new String[result.length];
        for (int i = 0; i < result.length; ++i) {
            try {
                res[i] = new String(result[i], "cp1251");
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                res[i] = new String(result[i]);
            }
        }
        return res;
    }

    @Override
    public synchronized OperationResult connect(String name) {
        if (name == null) {
            return new OperationResult(-1, true, "Specify connection name");
        }
        byte[] bytes = null;
        try {
            bytes = name.getBytes("cp1251");
        }
        catch (Exception ex) {
            bytes = name.getBytes();
        }
        int res = this.connectNative(bytes);
        return new OperationResult(res, res != 0, "");
    }

    @Override
    public synchronized OperationResult disconnect(String name) {
        if (name == null) {
            return new OperationResult(-1, true, "Specify connection name");
        }
        byte[] bytes = null;
        try {
            bytes = name.getBytes("cp1251");
        }
        catch (Exception ex) {
            bytes = name.getBytes();
        }
        int res = this.disconnectNative(bytes);
        return new OperationResult(res, res != 0, null);
    }

    @Override
    public synchronized OperationResult disconnectAll() {
        int res;
        return new OperationResult(res, (res = this.disconnectAllNative()) != 0, null);
    }

    @Override
    public synchronized int getConnectionState(String name) {
        this.init();
        if (name == null) {
            this.lastError = -1;
            this.lastErrorMessage = "Specify connection name";
            return -1;
        }
        byte[] bytes = null;
        try {
            bytes = name.getBytes("cp1251");
        }
        catch (Exception ex) {
            bytes = name.getBytes();
        }
        return this.getConnectionStateNative(bytes);
    }

    @Override
    public synchronized OperationResult getLastError() {
        return new OperationResult(this.lastError, this.error, this.lastErrorMessage);
    }

    private void init() {
        this.lastError = 0;
        this.lastErrorMessage = null;
    }

    private native byte[][] getConnectionsListNative();

    private native byte[][] getActiveConnectionsListNative();

    private native int connectNative(byte[] var1);

    private native int disconnectNative(byte[] var1);

    private native int disconnectAllNative();

    private native int getConnectionStateNative(byte[] var1);

    static {
        System.loadLibrary("ppp");
    }
}

