/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.services.identify.bdpn;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.input.model.utils.FileUtil;
import ru.softlogic.services.identify.MobileIdentifier;

class BdpnHashValidator
implements MobileIdentifier {
    private final File file;
    private Map<Short, Map<Integer, short[]>> data;

    public BdpnHashValidator(File file) {
        this.file = file;
    }

    @Override
    public short getOperator(String number) {
        int key = Integer.parseInt(number.substring(1, 6));
        short val = Short.parseShort(number.substring(6, 10));
        for (Map.Entry<Short, Map<Integer, short[]>> entry : this.data.entrySet()) {
            Map<Integer, short[]> m = entry.getValue();
            short[] ns = m.get(key);
            if (ns == null) continue;
            if (ns[0] != -1) {
                ns[0] = -1;
                Arrays.sort(ns);
            }
            if (Arrays.binarySearch(ns, 1, ns.length, val) <= 0) continue;
            return entry.getKey();
        }
        return -1;
    }

    @Override
    public void load() throws IOException {
        this.data = new HashMap<Short, Map<Integer, short[]>>();
        this.buildTree(this.file);
        this.fill(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTree(File file) throws IOException {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                short[] ns;
                String num = line.substring(1, 10);
                int key = Integer.parseInt(num.substring(0, 5));
                short idProv = Short.parseShort(line.substring(11, 12));
                Map<Integer, short[]> prvMap = this.data.get(idProv);
                if (prvMap == null) {
                    prvMap = new HashMap<Integer, short[]>();
                    this.data.put(idProv, prvMap);
                }
                if ((ns = prvMap.get(key)) == null) {
                    ns = new short[1];
                    prvMap.put(key, ns);
                }
                ns[0] = (short)(ns[0] + 1);
            }
        }
        catch (Throwable throwable) {
            FileUtil.close((Closeable[])new Closeable[]{br});
            throw throwable;
        }
        FileUtil.close((Closeable[])new Closeable[]{br});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill(File file) throws IOException {
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                String num = line.substring(1, 10);
                int key = Integer.parseInt(num.substring(0, 5));
                short val = Short.parseShort(num.substring(5, 9));
                short idProv = Short.parseShort(line.substring(11, 12));
                Map<Integer, short[]> set = this.data.get(idProv);
                short[] ns = set.get(key);
                if (ns.length == 1) {
                    ns = new short[ns[0] + 1];
                    ns[0] = 1;
                    set.put(key, ns);
                }
                short s = ns[0];
                ns[0] = (short)(s + 1);
                ns[s] = val;
            }
        }
        catch (Throwable throwable) {
            FileUtil.close((Closeable[])new Closeable[]{br});
            throw throwable;
        }
        FileUtil.close((Closeable[])new Closeable[]{br});
    }
}

