/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni.v2;

import org.w3c.dom.Element;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.parser.FormElementAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.ParserParams;
import ru.softlogic.parser.uni.v2.FormElementParser;
import ru.softlogic.parser.uni.v2.FormParserContext;
import ru.softlogic.parser.uni.v2.FormParserW3C;

@FormElementAnnotation(name="set-field")
class SetScreen
extends FormElementParser {
    SetScreen() {
    }

    @Override
    public InputElement parse(FormParserContext parserContext, Element element) throws ParseException {
        InputElement ie = new InputElement();
        String key = SetScreen.getAttribute(element, "name");
        String value = SetScreen.getAttribute(element, "value");
        value = this.checkValue("id1", key, value);
        value = this.checkValue("id2", key, value);
        ie.setKey(key);
        ie.setKeyTitle(SetScreen.getAttribute(element, "title"));
        ie.setValue(value);
        ie.setValueTitle(value);
        ie.setKeyTitleId(SetScreen.getAttribute(element, "key-title-id"));
        ie.setValueTitleId(SetScreen.getAttribute(element, "value-title-id"));
        int flags = this.getFlags(element);
        String showOnConfirm = SetScreen.getAttribute(element, "show-on-confirm");
        if (showOnConfirm != null && !Boolean.parseBoolean(showOnConfirm)) {
            flags |= 1;
        }
        ie.setFlags(flags);
        return ie;
    }

    private String checkValue(String name, String key, String value) throws ParseException {
        int params = FormParserW3C.getParams();
        if (!name.equals(key)) {
            return value;
        }
        if (value == null || value.isEmpty()) {
            throw new ParseException("Action 'set'. Value '" + name + "' is empty");
        }
        if (value.length() > 40) {
            if (ParserParams.hasFlag(params, "id1".equals(name) ? 64 : 128)) {
                throw new ParseException("Value '" + name + "' > 40 symbols");
            }
            return value.substring(0, 40);
        }
        return value;
    }
}

