/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni;

import java.io.File;
import java.io.InputStream;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.uni.FormPacker;
import ru.softlogic.parser.uni.FormParser;
import ru.softlogic.parser.uni.v2.FormParserW3C;

public class Parser {
    private static final FormParser formParser = new FormParserW3C();
    private static int params;

    private Parser() {
    }

    public static void setParams(int params) {
        Parser.params = params;
        formParser.setParams(params);
    }

    public static Form getForm(File file, short serviceId, File resourceDir) throws ParseException {
        Form form = formParser.getForm(file, Short.toString(serviceId), resourceDir);
        return Parser.packForm(form);
    }

    public static Form getForm(InputStream source, short serviceId, File resourceDir) throws ParseException {
        Form form = formParser.getForm(source, Short.toString(serviceId), resourceDir);
        return Parser.packForm(form);
    }

    public static Form getForm(String source, String serviceId, File resourceDir) throws ParseException {
        Form form = formParser.getForm(source, serviceId, resourceDir);
        return Parser.packForm(form);
    }

    private static Form packForm(Form form) {
        return FormPacker.pack(form, params);
    }
}

