/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni;

import java.util.ArrayList;
import java.util.List;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.ScreenSequence;
import ru.softlogic.input.model.field.barcode.BarcodeScanner;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.selector.SelectorField;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.custom.SequenceCustomData;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.parser.ParserParams;

public class FormPacker {
    private FormPacker() {
    }

    public static Form pack(Form form, int params) {
        boolean enable = ParserParams.hasFlag(params, 1);
        if (enable && form != null) {
            ScreenSequence formSequence = form.getScreenSequence();
            List<ScreenDescription> packScreenSequence = FormPacker.packScreenSequence(formSequence, params);
            form.setScreenSequence(new ScreenSequence(packScreenSequence, formSequence.getFields()));
        }
        return form;
    }

    private static List<ScreenDescription> packScreenSequence(ScreenSequence formSequence, int params) {
        ArrayList<ScreenDescription> sdList = new ArrayList<ScreenDescription>();
        FieldSequence resultSequence = new FieldSequence(new ArrayList());
        BarcodeScanner barcodeScanner = null;
        for (ScreenDescription sd : formSequence.getScreens()) {
            FieldSequence sequence;
            if (barcodeScanner == null) {
                barcodeScanner = sd.getBarcodeScanner();
            }
            boolean ignoreInfo = ParserParams.hasFlag(params, 2);
            if ("info".equals(sd.getType()) && !ignoreInfo) {
                if (resultSequence.getFields() != null && !resultSequence.getFields().isEmpty()) {
                    sdList.add(FormPacker.createGroupScreen(resultSequence, barcodeScanner));
                }
                sdList.add(sd);
            }
            if ((sequence = sd.getSequence()) == null) continue;
            FieldSequence packFieldSequence = FormPacker.packFieldSequence(sequence, params);
            resultSequence.getFields().addAll(packFieldSequence.getFields());
        }
        if (resultSequence.getFields() != null && !resultSequence.getFields().isEmpty()) {
            sdList.add(FormPacker.createGroupScreen(resultSequence, barcodeScanner));
        }
        return sdList;
    }

    private static ScreenDescription createGroupScreen(FieldSequence resultSequence, BarcodeScanner scanner) {
        ScreenDescription screenDescription = new ScreenDescription("letter");
        screenDescription.setSequence(resultSequence);
        screenDescription.setBarcodeScanner(scanner);
        return screenDescription;
    }

    private static FieldSequence packFieldSequence(FieldSequence sequence, int params) {
        boolean ignoreSumin = ParserParams.hasFlag(params, 4);
        FieldSequence resultSequence = new FieldSequence(new ArrayList());
        for (IdentityField field : sequence.getFields()) {
            String id;
            if (field.isNumeric() && "#sum".equals(id = ((NumericField)field).getId()) && ignoreSumin) continue;
            if (field instanceof SelectorField) {
                SelectorField selectorField = (SelectorField)field;
                for (SelectorItem item : selectorField.getItems()) {
                    SequenceCustomData scd;
                    ScreenSequence screenSequence;
                    Object obj = item.getCustomData().get("#sequence");
                    if (!(obj instanceof SequenceCustomData) || (screenSequence = (scd = (SequenceCustomData)obj).getScreenSequence()) == null) continue;
                    List<ScreenDescription> packScreenSequence = FormPacker.packScreenSequence(screenSequence, params);
                    ScreenSequence data = new ScreenSequence(packScreenSequence, screenSequence.getFields());
                    item.getCustomData().put("#sequence", new SequenceCustomData(data));
                }
            }
            resultSequence.getFields().add(field);
        }
        return resultSequence;
    }
}

