/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.factory.validator;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.softlogic.input.model.field.text.OrValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.parser.factory.validator.BaseConcreteFactory;
import ru.softlogic.parser.factory.validator.ValidatorCreatingException;
import ru.softlogic.parser.factory.validator.ValidatorFactory;

class OrFactory
extends BaseConcreteFactory {
    OrFactory() {
    }

    @Override
    public Validator createUni(Element element) throws ValidatorCreatingException {
        List<Element> validatorlList = this.getValidatorlList(element, "verify");
        ArrayList<Validator> vals = new ArrayList<Validator>();
        for (Element el : validatorlList) {
            vals.add(ValidatorFactory.createUni(el));
        }
        return new OrValidator(vals.toArray(new Validator[vals.size()]));
    }

    @Override
    public Validator createAdv(Element element) throws ValidatorCreatingException {
        List<Element> validatorlList = this.getValidatorlList(element, "validator");
        ArrayList<Validator> vals = new ArrayList<Validator>();
        for (Element el : validatorlList) {
            vals.add(ValidatorFactory.createAdv(el));
        }
        return new OrValidator(vals.toArray(new Validator[vals.size()]));
    }

    private List<Element> getValidatorlList(Element element, String tagName) throws ValidatorCreatingException {
        NodeList nl = element.getChildNodes();
        if (nl.getLength() == 0) {
            throw new ValidatorCreatingException("There are no child validators");
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node item = nl.item(i);
            if (item.getNodeType() != 1 || !tagName.equals(item.getNodeName())) continue;
            elements.add((Element)item);
        }
        return elements;
    }
}

