/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.factory.formatter;

import java.util.HashMap;
import org.w3c.dom.Element;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.RegexFormatter;
import ru.softlogic.parser.BaseElementParser;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.factory.formatter.ConcreteFormarrerFactory;

class RegexFormatterFactory
extends BaseElementParser
implements ConcreteFormarrerFactory {
    RegexFormatterFactory() {
    }

    @Override
    public Formatter createUni(Element element) throws ParseException {
        String padding = RegexFormatterFactory.getAttribute(element, "padding");
        if (padding != null && padding.length() != 1) {
            throw new ParseException("Padding must consist of 1 character");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        RegexFormatter formatter = new RegexFormatter();
        formatter.setDefaultMask(RegexFormatterFactory.getAttribute(element, "default"));
        if (padding != null) {
            formatter.setPadding(Character.valueOf(padding.charAt(0)));
        }
        formatter.setByStep(Boolean.valueOf(RegexFormatterFactory.getAttribute(element, "by-step")).booleanValue());
        for (Element rule : RegexFormatterFactory.getElements(element, "rule")) {
            map.put(RegexFormatterFactory.getAttribute(rule, "regex"), RegexFormatterFactory.getAttribute(rule, "value"));
        }
        formatter.setMasks(map);
        return formatter;
    }

    @Override
    public Formatter createAdv(Element element) throws ParseException {
        String padding = RegexFormatterFactory.getAttribute(element, "padding");
        if (padding != null && padding.length() != 1) {
            throw new ParseException("Padding must consist of 1 character");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        RegexFormatter formatter = new RegexFormatter();
        if (padding != null) {
            formatter.setPadding(Character.valueOf(padding.charAt(0)));
        }
        Element rules = RegexFormatterFactory.getElement(element, "rules");
        formatter.setDefaultMask(RegexFormatterFactory.getAttribute(rules, "default"));
        formatter.setByStep(Boolean.valueOf(RegexFormatterFactory.getAttribute(rules, "by-step")).booleanValue());
        for (Element rule : RegexFormatterFactory.getElements(rules, "rule")) {
            map.put(RegexFormatterFactory.getAttribute(rule, "regex"), RegexFormatterFactory.getAttribute(rule, "value"));
        }
        formatter.setMasks(map);
        return formatter;
    }
}

