/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.factory;

import java.util.Arrays;
import org.w3c.dom.Element;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardCase;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.parser.BaseElementParser;
import ru.softlogic.parser.ParseException;

public class KeyboardFactory
extends BaseElementParser {
    public static Keyboard createUni(Element elmnt) throws ParseException {
        String desc = KeyboardFactory.getAttribute(elmnt, "keyboard");
        String xbutton = KeyboardFactory.getAttribute(elmnt, "xbutton");
        return KeyboardFactory.loadKeyboardUni(desc.trim(), xbutton);
    }

    public static Keyboard createAdv(Element elmnt) throws ParseException {
        String desc = KeyboardFactory.getAttribute(elmnt, "keyboard");
        String xbutton = KeyboardFactory.getAttribute(elmnt, "xbutton");
        return KeyboardFactory.loadKeyboardAdv(desc.trim(), xbutton);
    }

    protected static Keyboard loadKeyboardUni(String desc, String xbutton) throws ParseException {
        Character extra;
        Character c = extra = xbutton == null || xbutton.isEmpty() ? null : Character.valueOf(xbutton.charAt(0));
        if (desc == null || desc.isEmpty() || "Digital".equalsIgnoreCase(desc)) {
            return new Keyboard(KeyboardType.Digital, extra);
        }
        String[] ps = desc.trim().split(":");
        KeyboardType kt = KeyboardFactory.getKeyboardType(ps[0]);
        if (kt == KeyboardType.Letter) {
            extra = null;
        }
        KeyboardCase keyCase = KeyboardFactory.getKeyboardCase(ps[2]);
        boolean ac = !"false".equals(ps[3]);
        String strLayout = ps[1].trim();
        if (!strLayout.isEmpty() && strLayout.startsWith("[") && strLayout.endsWith("]")) {
            String[] layouts = strLayout.replace("[", "").replace("]", "").replace(" ", "").split(",");
            return new Keyboard(kt, Arrays.asList(layouts), keyCase, ac, extra);
        }
        throw new ParseException("Invalid description keyboard format");
    }

    private static Keyboard loadKeyboardAdv(String desc, String xbutton) throws ParseException {
        Character extra;
        Character c = extra = xbutton == null ? null : Character.valueOf(xbutton.charAt(0));
        if (desc == null || desc.isEmpty() || "Digital".equalsIgnoreCase(desc)) {
            return new Keyboard(KeyboardType.Digital, extra);
        }
        String[] ps = desc.trim().split(":");
        if (ps.length != 6 && ps.length != 4) {
            throw new ParseException("Unknown keyboard description: " + desc);
        }
        KeyboardType kt = KeyboardFactory.getKeyboardType(ps[0]);
        if (kt == KeyboardType.Letter) {
            extra = null;
        }
        int pos = ps.length == 6 ? 4 : 2;
        KeyboardCase kc = KeyboardFactory.getKeyboardCase(ps[pos]);
        boolean ac = !"false".equals(ps[ps.length == 6 ? 5 : 3]);
        String strLayout = ps[1].trim();
        if (!strLayout.isEmpty() && strLayout.startsWith("[") && strLayout.endsWith("]")) {
            String[] layouts = ps[1].replace("[", "").replace("]", "").replace(" ", "").split(",");
            return new Keyboard(kt, Arrays.asList(layouts), kc, ac, extra);
        }
        return new Keyboard(kt, Arrays.asList(ps[1], ps[2], ps[3]), kc, ac, extra);
    }

    private static KeyboardType getKeyboardType(String param) throws ParseException {
        if ("letter".equalsIgnoreCase(param)) {
            return KeyboardType.Letter;
        }
        if ("digital".equalsIgnoreCase(param)) {
            return KeyboardType.Digital;
        }
        if ("any".equalsIgnoreCase(param)) {
            return KeyboardType.Any;
        }
        throw new ParseException("Unknown keyboard type: " + param);
    }

    private static KeyboardCase getKeyboardCase(String param) throws ParseException {
        if ("lower".equals(param)) {
            return KeyboardCase.Lower;
        }
        if ("upper".equals(param)) {
            return KeyboardCase.Upper;
        }
        throw new ParseException("Unknown case type: " + param);
    }
}

