/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2.fields;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.Modificator;
import ru.softlogic.input.model.field.text.NumericExternalValidator;
import ru.softlogic.input.model.field.text.NumericRangeValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoidFilter;
import ru.softlogic.input.model.field.text.VoidModificator;
import ru.softlogic.parser.FieldAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.adv.v2.fields.FieldParser;

@FieldAnnotation(name="numeric-field")
public class NumericField
extends FieldParser {
    @Override
    public List<? extends IdentityField> parse(Element field) throws ParseException {
        ru.softlogic.input.model.field.numeric.NumericField nf = new ru.softlogic.input.model.field.numeric.NumericField();
        this.prefillField((IdentityField)nf, field);
        nf.setFlags(this.getFlags(field));
        nf.setDefaultValue(NumericField.getAttribute(field, "default"));
        nf.setExampleValue(NumericField.getAttribute(field, "example"));
        nf.setErrorMessage(this.getErrorMessage(field));
        nf.setReadOnly(Boolean.parseBoolean(NumericField.getAttribute(field, "read-only")));
        nf.setExist(this.getExist(field));
        nf.setFilter((Filter)new VoidFilter());
        String format = NumericField.getNotNullAttribute(field, "format", "Numeric field. 'format' not found ");
        String[] tmp = format.split("\\.");
        if (tmp.length > 2) {
            throw new ParseException("Invalid format");
        }
        nf.setUnitCount(Integer.parseInt(tmp[0]));
        nf.setDecimalCount(Integer.parseInt(tmp.length > 1 ? tmp[1] : "0"));
        nf.setModificator((Modificator)new VoidModificator());
        nf.setKeyboard(new Keyboard(KeyboardType.Digital, nf.getDecimalCount() > 0 ? Character.valueOf('.') : null));
        String ud = NumericField.getAttribute(field, "updown");
        double udv = 0.0;
        if (ud != null) {
            udv = Double.parseDouble(ud);
        }
        nf.setUpdown(udv);
        Element verify = NumericField.getNotNullElement(field, "verify", "Verify not found");
        String verefyType = NumericField.getAttribute(verify, "type");
        if ("sumpurchase".equals(verefyType)) {
            nf.setValidator((Validator)new NumericExternalValidator());
        } else {
            List<Element> rangeList = NumericField.getElements(verify, "range");
            List<Range> ranges = this.buildNumericRanges(rangeList);
            nf.setValidator((Validator)new NumericRangeValidator(ranges));
        }
        return Collections.singletonList(nf);
    }

    private List<Range> buildNumericRanges(List<Element> rangeList) throws ParseException {
        LinkedList<Range> ranges = new LinkedList<Range>();
        for (Element rule : rangeList) {
            try {
                float begin = Float.parseFloat(NumericField.getAttribute(rule, "begin"));
                float end = Float.parseFloat(NumericField.getAttribute(rule, "end"));
                if (begin >= end) {
                    throw new ParseException("Invalid range: {begin=" + begin + ", end=" + end + '}');
                }
                ranges.add(new Range(begin, end));
            }
            catch (NumberFormatException ex) {
                throw new ParseException("Invalide range: " + rule.getTextContent(), ex);
            }
        }
        return ranges;
    }
}

