/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2.actions;

import org.w3c.dom.Element;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.validator.sequence.SequenceGenerator;
import ru.softlogic.input.model.advanced.actions.validator.sequence.SimpleSequenceGenerator;
import ru.softlogic.parser.ActionAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.ScenarioHelper;
import ru.softlogic.parser.adv.v2.ParserContext;
import ru.softlogic.parser.adv.v2.actions.ParseAction;

@ActionAnnotation(name="sequence-generator")
public class SequenceGenAction
extends ParseAction {
    @Override
    public ActionElement parse(Element element, ParserContext context) throws ParseException {
        String type = SequenceGenAction.getAttribute(element, "type");
        if ("simple".equals(type)) {
            return this.createSimpleGenerator(element, context);
        }
        throw new ParseException("Unknown type sequence generator:" + type);
    }

    private SequenceGenerator createSimpleGenerator(Element element, ParserContext context) throws ParseException {
        SimpleSequenceGenerator ssg = new SimpleSequenceGenerator();
        ssg.setName(SequenceGenAction.getAttribute(element, "name"));
        ssg.setStart(SequenceGenAction.getAttribute(element, "start"));
        ssg.setEnd(SequenceGenAction.getAttribute(element, "end"));
        ssg.setLoop("true".equals(SequenceGenAction.getAttribute(element, "loop")));
        ssg.setNoIncrement("true".equals(SequenceGenAction.getAttribute(element, "no-increment")));
        ssg.setResultKey(SequenceGenAction.getAttribute(element, "result-key"));
        ssg.setResultTitle(SequenceGenAction.getAttribute(element, "result-title"));
        ssg.setActionMap(ScenarioHelper.createActionMap(element, context));
        if (ssg.getName() == null || ssg.getName().trim().isEmpty()) {
            throw new ParseException("Sequence-generator. Parameter 'name' not set");
        }
        if (ssg.getResultKey() == null || ssg.getResultKey().trim().isEmpty()) {
            throw new ParseException("Sequence-generator. Parameter 'result-key' not set");
        }
        return ssg;
    }
}

