/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.hdw.CardDispenserRequest;
import ru.softlogic.input.model.advanced.actions.hdw.CardReaderRequest;
import ru.softlogic.input.model.advanced.actions.hdw.SmartCardRequest;
import ru.softlogic.input.model.advanced.actions.hdw.WebcamRequest;
import ru.softlogic.parser.ActionAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.ScenarioHelper;
import ru.softlogic.parser.adv.v2.ParserContext;
import ru.softlogic.parser.adv.v2.actions.ParseAction;

@ActionAnnotation(name="hdw-request")
public class HdwRequestAction
extends ParseAction {
    @Override
    public ActionElement parse(Element element, ParserContext context) throws ParseException {
        String function = HdwRequestAction.getAttribute(element, "function");
        String type = HdwRequestAction.getAttribute(element, "type");
        String params = HdwRequestAction.getAttribute(element, "params");
        List<Object> paramValue = params != null ? Arrays.asList(params.split(",")) : new ArrayList();
        ActionMap actionMap = ScenarioHelper.createActionMap(element, context);
        if ("smart-card".equals(type)) {
            context.addFeature(4);
            return new SmartCardRequest(function, paramValue, actionMap);
        }
        if ("card-reader".equals(type)) {
            context.addFeature(1);
            return new CardReaderRequest(function, paramValue, actionMap);
        }
        if ("card-dispenser".equals(type)) {
            context.addFeature(2);
            return new CardDispenserRequest(function, paramValue, actionMap);
        }
        if ("webcam".equals(type)) {
            context.addFeature(8);
            return new WebcamRequest(function, paramValue, actionMap);
        }
        throw new ParseException("HdwRequest.Unknown type of request:" + type);
    }
}

