/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ru.softlogic.input.model.RowParams;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.PaymentParams;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.input.model.advanced.SlaveScenarioParser;
import ru.softlogic.input.model.advanced.configuration.RuntimeConfiguration;
import ru.softlogic.parser.BaseElementParser;
import ru.softlogic.parser.ParseElementSearcher;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.adv.ScenarioParser;
import ru.softlogic.parser.adv.v2.ParserContext;
import ru.softlogic.parser.adv.v2.ScreenParserImpl;
import ru.softlogic.parser.adv.v2.actions.ParseAction;
import ru.softlogic.parser.adv.v2.fields.FieldParser;
import ru.softlogic.parser.adv.v2.screens.ScreenParser;
import ru.softlogic.parser.decrypt.DecryptUtils;

public class ScenarioParserW3C
extends BaseElementParser
implements ScenarioParser {
    public static final long serialVersionUID = 0L;
    private static final Map<String, ScreenParser> screensMap;
    private static final Map<String, ParseAction> actionsMap;
    private static final Map<String, FieldParser> fieldsMap;
    private static final Map<String, RowParams> rowParamsMap;
    private static volatile int params;

    public static Map<String, ScreenParser> getScreensMap() {
        return screensMap;
    }

    public static Map<String, ParseAction> getActionsMap() {
        return actionsMap;
    }

    public static Map<String, FieldParser> getFieldsMap() {
        return fieldsMap;
    }

    public static Map<String, RowParams> getRowParamsMap() {
        return rowParamsMap;
    }

    @Override
    public void setParams(int params) {
        ScenarioParserW3C.params = params;
    }

    public static int getParams() {
        return params;
    }

    @Override
    public Scenario parse(File file) throws ParseException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        Document doc = ScenarioParserW3C.getDocument(file);
        doc.getDocumentElement().normalize();
        Element el = doc.getDocumentElement();
        return this.parseDomElement(el, file);
    }

    @Override
    public Scenario parse(String document) throws ParseException {
        Document doc = ScenarioParserW3C.getDocument(document);
        doc.getDocumentElement().normalize();
        Element el = doc.getDocumentElement();
        return this.parseDomElement(el, null);
    }

    private Scenario parseDomElement(Element el, File file) throws ParseException {
        NodeList screen;
        String begin = ScenarioParserW3C.getAttribute(el, "begin");
        if (begin == null) {
            throw new ParseException("The startup screen is not set");
        }
        String beginProcess = ScenarioParserW3C.getAttribute(el, "begin-process");
        String beginEdit = ScenarioParserW3C.getAttribute(el, "begin-edit");
        String beginTemplate = ScenarioParserW3C.getAttribute(el, "begin-template");
        String beginTemplateEdit = ScenarioParserW3C.getAttribute(el, "begin-template-edit");
        String cardHandler = ScenarioParserW3C.getAttribute(el, "scard-handler");
        String attrChangeNumber = ScenarioParserW3C.getAttribute(el, "chnum-name");
        String changeNumber = attrChangeNumber != null ? attrChangeNumber : "chnum";
        ParserContext context = new ParserContext();
        NodeList payParams = el.getElementsByTagName("payment-params");
        PaymentParams paymentParams = null;
        if (payParams.getLength() == 1) {
            Element scenParams = (Element)payParams.item(0);
            paymentParams = new PaymentParams();
            paymentParams.setKey(ScenarioParserW3C.getAttribute(scenParams, "key"));
            paymentParams.setDistributionType(ScenarioParserW3C.getAttribute(scenParams, "distribution-type"));
            String singleCheck = ScenarioParserW3C.getAttribute(scenParams, "single-check");
            paymentParams.setSingleCheck(Boolean.parseBoolean(singleCheck));
            String firstParam = ScenarioParserW3C.getAttribute(scenParams, "first-params-context");
            paymentParams.setFirstParamsContext(Boolean.parseBoolean(firstParam));
            String allowReturn = ScenarioParserW3C.getAttribute(scenParams, "allow-return");
            paymentParams.setAllowReturn(Boolean.parseBoolean(allowReturn));
        }
        if ((screen = el.getElementsByTagName("screen")).getLength() == 0) {
            throw new ParseException("Screens were not found");
        }
        HashMap<String, AdvancedScreenDescription> screens = new HashMap<String, AdvancedScreenDescription>();
        for (int i = 0; i < screen.getLength(); ++i) {
            Element item = (Element)screen.item(i);
            String name = ScenarioParserW3C.getValidScreenName(item.getAttribute("type"));
            ScreenParser screenParser = screensMap.get(name);
            if (screenParser == null) {
                screenParser = screensMap.get("default");
            }
            if (screenParser == null) {
                throw new ParseException("Unknown type screen: " + name);
            }
            AdvancedScreenDescription asd = screenParser.parse(item, context);
            if (asd == null) continue;
            if (screens.get(asd.getDescription().getId()) != null) {
                throw new ParseException("Duplicated IDs screens: " + asd.getDescription().getId());
            }
            screens.put(asd.getDescription().getId(), asd);
        }
        String feats = ScenarioParserW3C.getAttribute(el, "features");
        String cFeats = ScenarioParserW3C.getAttribute(el, "check-features");
        int features = (feats != null && feats.matches("\\d+") ? Integer.parseInt(feats) : 0) | context.getFeatures();
        int checkFeatures = cFeats != null && cFeats.matches("\\d+") ? Integer.parseInt(cFeats) : -1;
        return new Scenario(begin, beginProcess, beginEdit, cardHandler, changeNumber, screens, paymentParams, this.loadPrefillItems(el), features, checkFeatures, (SlaveScenarioParser)new ScreenParserImpl(this, file), beginTemplate, rowParamsMap.isEmpty() ? null : rowParamsMap, beginTemplateEdit);
    }

    private static String getValidScreenName(String name) throws ParseException {
        if (name == null || name.isEmpty()) {
            throw new ParseException("Screen name not specified.");
        }
        int index = name.indexOf(47);
        if (index > 0) {
            name = name.substring(0, index);
        }
        return name.toLowerCase();
    }

    private static Document getDocument(File file) throws ParseException {
        try {
            return ScenarioParserW3C.createDocumentBuilder().parse(ScenarioParserW3C.getInputStream(file), "UTF8");
        }
        catch (SAXException ex) {
            throw new ParseException(ex);
        }
        catch (IOException ex) {
            throw new ParseException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ParseException(ex);
        }
    }

    private static Document getDocument(String string) throws ParseException {
        try {
            return ScenarioParserW3C.createDocumentBuilder().parse(new ByteArrayInputStream(string.getBytes("UTF-8")));
        }
        catch (SAXException ex) {
            throw new ParseException(ex);
        }
        catch (IOException ex) {
            throw new ParseException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new ParseException(ex);
        }
    }

    private static InputStream getInputStream(File file) throws IOException {
        InputStream fis;
        if (file.getAbsolutePath().endsWith(".enc")) {
            String password = RuntimeConfiguration.getInstance().getPassword();
            fis = ScenarioParserW3C.openGZIPInputStream(DecryptUtils.decrypt(file, password));
        } else {
            fis = file.getAbsolutePath().endsWith(".gz") ? ScenarioParserW3C.openGZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
        }
        return new BufferedInputStream(fis);
    }

    private static GZIPInputStream openGZIPInputStream(InputStream stream) throws IOException {
        try {
            return new GZIPInputStream(stream);
        }
        catch (IOException ex) {
            stream.close();
            throw ex;
        }
    }

    private static DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        if ((params & 0x100) == 0) {
            try {
                dbFactory.setXIncludeAware(true);
                dbFactory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        dbFactory.setNamespaceAware(true);
        return dbFactory.newDocumentBuilder();
    }

    static {
        rowParamsMap = new HashMap<String, RowParams>();
        screensMap = ParseElementSearcher.getAllScreens();
        actionsMap = ParseElementSearcher.getAllActions();
        fieldsMap = ParseElementSearcher.getAllFields();
        params = 16;
    }
}

