/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.queue;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.security.KeyStore;
import java.security.SignedObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.cashin.validator.statistics.Statistics;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.reference.adv.AdvStatistic;
import ru.softlogic.srv.api.card.SaleConfirm;
import ru.softlogic.srv.api.cbc.CbcStatus;
import ru.softlogic.srv.api.command.CommandResult;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.event.EventType;
import ru.softlogic.srv.api.iface.NetworkDevice;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.network.NetworkStatistics;
import ru.softlogic.srv.api.oth.Demand;
import ru.softlogic.srv.api.oth.JammInfo;
import ru.softlogic.srv.api.oth.SystemInfo;
import ru.softlogic.srv.api.security.EnvRiskFactors;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.api.status.UpdateState;
import ru.softlogic.srv.connector.ZReportInfo;
import ru.softlogic.srv.connector.ws.stub.BoxAmount;
import ru.softlogic.srv.connector.ws.stub.BoxInfo;
import ru.softlogic.srv.connector.ws.stub.BoxStatus;
import ru.softlogic.srv.connector.ws.stub.EncashmentResult;
import ru.softlogic.srv.queue.DiskErrorListener;
import ru.softlogic.srv.queue.QueueData;
import ru.softlogic.srv.queue.QueueStatus;
import ru.softlogic.srv.queue.QueueUtils;
import ru.softlogic.system.util.ObjectReadWriteStream;

public class Queue {
    private Integer diskSpace;
    private List<DeviceStatus> deviceStatuses;
    private List<DeviceInfo> deviceInfos;
    private List<BoxStatus> dispenserBoxStatuses;
    private List<BoxInfo> dispenserBoxInfos;
    private List<BoxAmount> dispenserBoxAmounts;
    private NetworkDevice[] networkDevices;
    private List<UpdateState> updateStates;
    private SystemInfo systemInfo;
    private EnvRiskFactors envRiskFactors;
    private QueueData queueData;
    private Logger log;
    private boolean diskError;
    private ObjectReadWriteStream mainFile;
    private ObjectReadWriteStream tmpFile;
    private DiskErrorListener listener;
    private KeyStore keyStore;

    public Queue(String fileName, DiskErrorListener listener) {
        this.listener = listener;
        this.log = Logger.getLogger((String)"net");
        this.log.setAdditivity(false);
        this.printFileSize(fileName);
        this.printFileSize(fileName + ".tmp");
        this.keyStore = this.getKeyStore();
        try {
            this.mainFile = new ObjectReadWriteStream(fileName);
            this.tmpFile = new ObjectReadWriteStream(fileName + ".tmp");
            this.diskError = false;
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0430", (Throwable)ex);
            this.diskError = true;
        }
        this.deviceStatuses = new LinkedList<DeviceStatus>();
        this.deviceInfos = new LinkedList<DeviceInfo>();
        this.dispenserBoxStatuses = new LinkedList<BoxStatus>();
        this.dispenserBoxInfos = new LinkedList<BoxInfo>();
        this.dispenserBoxAmounts = new LinkedList<BoxAmount>();
        this.updateStates = new LinkedList<UpdateState>();
        this.readData();
    }

    public synchronized QueueStatus getStatus() {
        QueueStatus qs = new QueueStatus(this.queueData.getAge() / 60000L, this.queueData.getSize(), this.diskError, this.queueData.isRemoteLock());
        if (qs.getSize() > 0 || qs.getTimeout() > 0L) {
            this.log.debug((Object)("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + qs));
        }
        return qs;
    }

    public synchronized boolean putOperation(Operation operation) {
        if (operation != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f: " + operation));
            this.queueData.getFinancialQueue().add((Serializable)operation);
            return this.saveData();
        }
        return true;
    }

    public synchronized Operation[] getOperations() {
        return this.getFirstEntries(Operation.class);
    }

    public synchronized void deleteOperations(Operation[] opers) {
        if (opers != null) {
            for (Operation op : opers) {
                if (this.queueData.getFinancialQueue().remove(op)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0438\u0437 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + op));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + op));
            }
            this.saveData();
        }
    }

    public synchronized boolean putGroupOperation(GroupOperation operation) {
        if (operation != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f: " + operation));
            this.queueData.getFinancialQueue().add((Serializable)operation);
            return this.saveData();
        }
        return true;
    }

    public synchronized GroupOperation[] getGroupOperations() {
        return this.getFirstEntries(GroupOperation.class);
    }

    public synchronized void deleteGroupOperations(GroupOperation[] opers) {
        if (opers != null) {
            for (GroupOperation op : opers) {
                if (this.queueData.getFinancialQueue().remove(op)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0438\u0437 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + op));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + op));
            }
            this.saveData();
        }
    }

    public synchronized Operation[] getAllOperations() {
        LinkedList<Operation> op = null;
        if (!this.queueData.getFinancialQueue().isEmpty()) {
            op = new LinkedList<Operation>();
            for (Serializable obj : this.queueData.getFinancialQueue()) {
                if (!(obj instanceof Operation)) continue;
                op.add((Operation)obj);
            }
        }
        return op == null || op.isEmpty() ? null : op.toArray(new Operation[op.size()]);
    }

    public synchronized boolean putDeviceStatus(DeviceStatus deviceStatus) {
        if (deviceStatus != null) {
            Iterator<DeviceStatus> i = this.deviceStatuses.iterator();
            while (i.hasNext()) {
                DeviceStatus ds = i.next();
                if (ds.getDeviceClass() != deviceStatus.getDeviceClass()) continue;
                this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d \u043d\u0435\u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: " + ds));
                i.remove();
            }
            this.log.info((Object)("\u041d\u043e\u0432\u044b\u0439 \u0430\u043a\u0442\u0443\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441: " + deviceStatus));
            this.deviceStatuses.add(deviceStatus);
            return true;
        }
        return true;
    }

    public synchronized DeviceStatus[] getDeviceStatuses() {
        if (!this.deviceStatuses.isEmpty()) {
            return this.deviceStatuses.toArray(new DeviceStatus[this.deviceStatuses.size()]);
        }
        return null;
    }

    public synchronized void deleteDeviceStatuses(DeviceStatus[] statuses) {
        if (statuses != null) {
            for (DeviceStatus ds : statuses) {
                if (this.deviceStatuses.remove(ds)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + ds));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + ds));
            }
        }
    }

    public synchronized boolean putEvent(Event event) {
        if (event != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u043e\u0432\u043e\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u0435: " + event));
            if (event.getComment() != null) {
                event.setComment(event.getComment().replaceAll("\\p{C}", "?"));
            }
            this.queueData.getEvents().add(event);
            return this.saveData();
        }
        return true;
    }

    public synchronized Event[] getEvents() {
        if (!this.queueData.getEvents().isEmpty()) {
            return this.queueData.getEvents().toArray(new Event[this.queueData.getEvents().size()]);
        }
        return null;
    }

    public synchronized void deleteEvents(Event[] evts) {
        if (evts != null) {
            for (Event e : evts) {
                if (this.queueData.getEvents().remove(e)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u043e \u0441\u043e\u0431\u044b\u0442\u0438\u0435 " + e));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0441\u043e\u0431\u044b\u0442\u0438\u044f " + e));
            }
            this.saveData();
        }
    }

    public synchronized boolean putZReportInfo(ZReportInfo info) {
        if (info != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u043e\u0432\u044b\u0439 z-\u043e\u0442\u0447\u0435\u0442: " + info));
            this.queueData.getZReportInfos().add(info);
            return this.saveData();
        }
        return true;
    }

    public synchronized ZReportInfo[] getZReportInfos() {
        if (!this.queueData.getZReportInfos().isEmpty()) {
            return this.queueData.getZReportInfos().toArray(new ZReportInfo[this.queueData.getZReportInfos().size()]);
        }
        return null;
    }

    public synchronized void deleteZReportInfo(ZReportInfo[] infos) {
        if (infos != null) {
            for (ZReportInfo e : infos) {
                if (this.queueData.getZReportInfos().remove(e)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d z-\u043e\u0442\u0447\u0435\u0442 " + e));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 z-\u043e\u0442\u0447\u0435\u0442\u0430 " + e));
            }
            this.saveData();
        }
    }

    public synchronized boolean putMoneyCollection(MoneyCollection mc) {
        if (mc != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f: " + mc));
            this.queueData.getFinancialQueue().add((Serializable)mc);
            return this.saveData();
        }
        return true;
    }

    public synchronized MoneyCollection[] getMoneyCollections() {
        return this.getFirstEntries(MoneyCollection.class);
    }

    public synchronized void deleteMoneyCollections(MoneyCollection[] mcs) {
        if (mcs != null) {
            for (MoneyCollection mc : mcs) {
                if (this.queueData.getFinancialQueue().remove(mc)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u0430 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u044f \u0438\u0437 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + mc));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: " + mc));
            }
            this.saveData();
        }
    }

    public synchronized boolean putEncashmentResult(EncashmentResult result) {
        if (result != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u043e\u0439 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: " + result));
            this.queueData.getFinancialQueue().add(result);
            return this.saveData();
        }
        return true;
    }

    public synchronized void deleteEncashmentResult(EncashmentResult encashmentResult) {
        if (encashmentResult != null) {
            if (this.queueData.getFinancialQueue().remove(encashmentResult)) {
                this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0439 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438 \u0438\u0437 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u043e\u0447\u0435\u0440\u0435\u0434\u0438: " + encashmentResult));
            } else {
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0443\u0434\u0430\u043b\u0435\u043d\u043d\u043e\u0439 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0438: " + encashmentResult));
            }
            this.saveData();
        }
    }

    public synchronized EncashmentResult[] getEncashmentResults() {
        return this.getFirstEntries(EncashmentResult.class);
    }

    public synchronized boolean putStatistics(Statistics st) {
        if (st != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u043e\u0432\u0430\u044f \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430: " + st));
            this.queueData.getStatistics().add(st);
            return this.saveData();
        }
        return true;
    }

    public synchronized Statistics[] getStatistics() {
        if (!this.queueData.getStatistics().isEmpty()) {
            return this.queueData.getStatistics().toArray(new Statistics[this.queueData.getStatistics().size()]);
        }
        return null;
    }

    public synchronized void deleteStatistics(Statistics[] stats) {
        if (stats != null) {
            for (Statistics s : stats) {
                if (this.queueData.getStatistics().remove(s)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u043e \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 " + s));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 " + s));
            }
            this.saveData();
        }
    }

    public synchronized boolean putAdvStatistics(List<AdvStatistic> st) {
        if (st != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u043e\u0432\u0430\u044f adv \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430: " + st));
            this.queueData.getAdvStatistics().addAll(st);
            return this.saveData();
        }
        return true;
    }

    public synchronized AdvStatistic[] getAdvStatistics() {
        if (!this.queueData.getAdvStatistics().isEmpty()) {
            return this.queueData.getAdvStatistics().toArray(new AdvStatistic[this.queueData.getAdvStatistics().size()]);
        }
        return null;
    }

    public synchronized void deleteAdvStatistics(AdvStatistic[] stats) {
        if (stats != null) {
            for (AdvStatistic s : stats) {
                if (this.queueData.getAdvStatistics().remove(s)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u043e adv \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 " + s));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 adv \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 " + s));
            }
            this.saveData();
        }
    }

    public synchronized boolean putSaleConfirm(SaleConfirm sc) {
        if (sc != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e \u043d\u043e\u0432\u043e\u0435 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0430\u0436\u0438 \u043a\u0430\u0440\u0442\u044b: " + sc));
            this.queueData.getSaleConfirms().add(sc);
            return this.saveData();
        }
        return true;
    }

    public synchronized SaleConfirm[] getSaleConfirms() {
        if (!this.queueData.getSaleConfirms().isEmpty()) {
            return this.queueData.getSaleConfirms().toArray(new SaleConfirm[this.queueData.getSaleConfirms().size()]);
        }
        return null;
    }

    public synchronized void deleteSaleConfirms(SaleConfirm[] cnfs) {
        if (cnfs != null) {
            for (SaleConfirm s : cnfs) {
                if (this.queueData.getSaleConfirms().remove(s)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u043e \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0430\u0436\u0438 " + s));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0438 " + s));
            }
            this.saveData();
        }
    }

    public synchronized boolean putDeviceInfo(DeviceInfo di) {
        if (di != null) {
            di.setFirmware(di.getFirmware().replaceAll("\\p{C}", "?"));
            di.setFirmware1(di.getFirmware1().replaceAll("\\p{C}", "?"));
            di.setFirmware2(di.getFirmware2().replaceAll("\\p{C}", "?"));
            di.setInfo(di.getInfo().replaceAll("\\p{C}", "?"));
            di.setModel(di.getModel().replaceAll("\\p{C}", "?"));
            di.setSerial(di.getSerial().replaceAll("\\p{C}", "?"));
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043d\u043e\u0432\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u0438: " + di));
            this.deviceInfos.add(di);
        }
        return true;
    }

    public synchronized DeviceInfo[] getDeviceInfo() {
        if (!this.deviceInfos.isEmpty()) {
            return this.deviceInfos.toArray(new DeviceInfo[this.deviceInfos.size()]);
        }
        return null;
    }

    public synchronized void deleteDeviceInfos(DeviceInfo[] devin) {
        if (devin != null) {
            for (DeviceInfo d : devin) {
                if (this.deviceInfos.remove(d)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u0438 " + d));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e\u0431 \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u0438 " + d));
            }
        }
    }

    public synchronized boolean putDispenserBoxInfo(BoxInfo bi) {
        if (bi != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043d\u043e\u0432\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0431\u043e\u043a\u0441\u0430\u0445 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430: " + bi));
            this.dispenserBoxInfos.add(bi);
        }
        return true;
    }

    public synchronized BoxInfo[] getDispenserBoxInfos() {
        if (!this.dispenserBoxInfos.isEmpty()) {
            return this.dispenserBoxInfos.toArray(new BoxInfo[this.dispenserBoxInfos.size()]);
        }
        return null;
    }

    public synchronized void deleteDispenserBoxInfos(BoxInfo[] devin) {
        if (devin != null) {
            for (BoxInfo d : devin) {
                if (this.dispenserBoxInfos.remove(d)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0431\u043e\u043a\u0441\u0435 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 " + d));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043e \u0431\u043e\u043a\u0441\u0435 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 " + d));
            }
        }
    }

    public synchronized boolean putDispenserBoxStatus(BoxStatus bs) {
        if (bs != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u0431\u043e\u043a\u0441\u0430 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430: " + bs));
            this.dispenserBoxStatuses.add(bs);
        }
        return true;
    }

    public synchronized BoxStatus[] getDispenserBoxStatuses() {
        if (!this.dispenserBoxStatuses.isEmpty()) {
            return this.dispenserBoxStatuses.toArray(new BoxStatus[this.dispenserBoxStatuses.size()]);
        }
        return null;
    }

    public synchronized void deleteDispenserBoxStatuses(BoxStatus[] devin) {
        if (devin != null) {
            for (BoxStatus d : devin) {
                if (this.dispenserBoxStatuses.remove(d)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0435 \u0431\u043e\u043a\u0441\u0430 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 " + d));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0435 \u0431\u043e\u043a\u0441\u0430 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 " + d));
            }
        }
    }

    public synchronized boolean putDispenserBoxAmount(BoxAmount ba) {
        if (ba != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u043d\u043e\u0432\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0437\u0430\u043f\u043e\u043b\u0435\u043d\u043d\u043e\u0441\u0442\u0438 \u0431\u043e\u043a\u0441\u0430 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430: " + ba));
            this.dispenserBoxAmounts.add(ba);
        }
        return true;
    }

    public synchronized BoxAmount[] getDispenserBoxAmounts() {
        if (!this.dispenserBoxAmounts.isEmpty()) {
            return this.dispenserBoxAmounts.toArray(new BoxAmount[this.dispenserBoxAmounts.size()]);
        }
        return null;
    }

    public synchronized void deleteDispenserBoxAmounts(BoxAmount[] devin) {
        if (devin != null) {
            for (BoxAmount d : devin) {
                if (this.dispenserBoxAmounts.remove(d)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0435 \u0431\u043e\u043a\u0441\u0430 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 " + d));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0435 \u0431\u043e\u043a\u0441\u0430 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 " + d));
            }
        }
    }

    public synchronized boolean putUpdateStatus(UpdateState updateStatus) {
        if (updateStatus != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f: " + updateStatus));
            this.updateStates.add(updateStatus);
        }
        return true;
    }

    public synchronized UpdateState[] getUpdateStates() {
        if (!this.updateStates.isEmpty()) {
            return this.updateStates.toArray(new UpdateState[this.updateStates.size()]);
        }
        return null;
    }

    public synchronized void deleteUpdateStatus(UpdateState updateStatus) {
        if (updateStatus != null) {
            this.updateStates.remove(updateStatus);
        }
    }

    public synchronized boolean putModemState(ModemState modemState) {
        if (modemState != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441 \u043c\u043e\u0434\u0435\u043c\u0430: " + modemState));
            this.queueData.getModemStates().clear();
            this.queueData.getModemStates().add(modemState);
            return this.saveData();
        }
        return true;
    }

    public synchronized ModemState getModemState() {
        if (this.queueData.getModemStates().isEmpty()) {
            return null;
        }
        return this.queueData.getModemStates().get(0);
    }

    public synchronized void deleteModemState(ModemState modemState) {
        this.queueData.getModemStates().remove(modemState);
        this.saveData();
    }

    public synchronized boolean putNetworkDevices(NetworkDevice[] networkDevices) {
        if (networkDevices != null) {
            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u044b \u0441\u0435\u0442\u0435\u0432\u044b\u0435 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u044b");
            this.networkDevices = networkDevices;
        }
        return true;
    }

    public synchronized NetworkDevice[] getNetworkDevices() {
        return this.networkDevices;
    }

    public synchronized void deleteNetworkDevices(NetworkDevice[] networkDevices) {
        if (this.networkDevices == networkDevices) {
            this.networkDevices = null;
        }
    }

    public synchronized boolean putCommandResult(CommandResult commandResult) {
        if (commandResult != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043d\u043e\u0432\u044b\u0439 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b: " + commandResult));
            this.queueData.getCommandResults().add(commandResult);
            return this.saveData();
        }
        return true;
    }

    public synchronized CommandResult[] getCommandResults() {
        if (!this.queueData.getCommandResults().isEmpty()) {
            return this.queueData.getCommandResults().toArray(new CommandResult[this.queueData.getCommandResults().size()]);
        }
        return null;
    }

    public synchronized void deleteCommandResults(CommandResult[] commandResults) {
        if (commandResults != null) {
            for (CommandResult cr : commandResults) {
                if (this.queueData.getCommandResults().remove(cr)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0431 \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u0438 " + cr));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438 \u043e\u0431 \u043e\u0431\u043e\u0440\u0443\u0434\u043e\u0432\u0430\u043d\u0438\u0438 " + cr));
            }
            this.saveData();
        }
    }

    public void setDiskSpace(Integer space) {
        this.diskSpace = space;
    }

    public Integer getDiskSpace() {
        return this.diskSpace;
    }

    public synchronized boolean putJamm(JammInfo jammInfo) {
        if (jammInfo != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0437\u0430\u0436\u0435\u0432\u044b\u0432\u0430\u043d\u0438\u0438: " + jammInfo));
            this.queueData.getJammInfos().add(jammInfo);
            return this.saveData();
        }
        return true;
    }

    public synchronized JammInfo[] getJamms() {
        if (!this.queueData.getJammInfos().isEmpty()) {
            return this.queueData.getJammInfos().toArray(new JammInfo[this.queueData.getJammInfos().size()]);
        }
        return null;
    }

    public synchronized void deleteJamm(JammInfo[] jammInfos) {
        if (jammInfos != null) {
            for (JammInfo jammInfo : jammInfos) {
                if (this.queueData.getJammInfos().remove(jammInfo)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + jammInfo));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + jammInfo));
            }
            this.saveData();
        }
    }

    public synchronized boolean putNetworkStatistics(NetworkStatistics ns) {
        if (ns != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0441\u0435\u0442\u0438 " + ns));
            this.queueData.getNetworkStatistics().add(ns);
            return this.saveData();
        }
        return true;
    }

    public synchronized NetworkStatistics[] getNetworkStatistics() {
        if (!this.queueData.getNetworkStatistics().isEmpty()) {
            return this.queueData.getNetworkStatistics().toArray(new NetworkStatistics[this.queueData.getNetworkStatistics().size()]);
        }
        return null;
    }

    public synchronized void deleteNetworkStatistics(NetworkStatistics[] networkStatistics) {
        if (networkStatistics != null) {
            for (NetworkStatistics ns : networkStatistics) {
                if (this.queueData.getNetworkStatistics().remove(ns)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d\u0430 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + ns));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0430 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + ns));
            }
            this.saveData();
        }
    }

    public synchronized boolean putCbcStatus(CbcStatus cbcStatus) {
        if (cbcStatus != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0433\u0430\u0448\u0435\u043d\u0438\u044f \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438 " + cbcStatus));
            this.queueData.getCbcStates().add(cbcStatus);
            return this.saveData();
        }
        return true;
    }

    public synchronized CbcStatus[] getCbcStates() {
        if (!this.queueData.getCbcStates().isEmpty()) {
            return this.queueData.getCbcStates().toArray(new CbcStatus[this.queueData.getCbcStates().size()]);
        }
        return null;
    }

    public synchronized void deleteCbcStates(CbcStatus[] cbcStates) {
        if (cbcStates != null) {
            for (CbcStatus csr : cbcStates) {
                if (this.queueData.getCbcStates().remove(csr)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u0433\u0430\u0448\u0435\u043d\u0438\u044f \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + csr));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0430 \u0433\u0430\u0448\u0435\u043d\u0438\u044f \u043a\u0430\u0440\u0442\u044b \u0441\u0434\u0430\u0447\u0438 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + csr));
            }
            this.saveData();
        }
    }

    public synchronized boolean putDemand(Demand demand) {
        if (demand != null) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u0437\u0430\u043f\u0440\u043e\u0441 " + demand));
            this.queueData.getDemandes().add(demand);
            return this.saveData();
        }
        return true;
    }

    public synchronized Demand[] getDemands() {
        if (!this.queueData.getDemandes().isEmpty()) {
            return this.queueData.getDemandes().toArray(new Demand[this.queueData.getDemandes().size()]);
        }
        return null;
    }

    public synchronized void deleteDemand(Demand[] demands) {
        if (demands != null) {
            for (Demand csr : demands) {
                if (this.queueData.getDemandes().remove(csr)) {
                    this.log.info((Object)("\u0423\u0434\u0430\u043b\u0435\u043d \u0437\u0430\u043f\u0440\u043e\u0441 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + csr));
                    continue;
                }
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u0438\u0437 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 " + csr));
            }
            this.saveData();
        }
    }

    public synchronized SystemInfo getSystemInfo() {
        return this.systemInfo;
    }

    public synchronized void setSystemInfo(SystemInfo systemInfo) {
        this.log.info((Object)("set sysinfo: " + systemInfo));
        this.systemInfo = systemInfo;
    }

    public synchronized EnvRiskFactors getEnvRiskFactors() {
        return this.envRiskFactors;
    }

    public synchronized void setEnvRiskFactors(EnvRiskFactors envRiskFactors) {
        this.log.info((Object)("set risk factors: " + envRiskFactors));
        this.envRiskFactors = envRiskFactors;
    }

    public boolean isRemoteLock() {
        return this.queueData.isRemoteLock();
    }

    public void setRemoteLock(boolean remoteLock) {
        this.queueData.setRemoteLock(remoteLock);
        this.saveData();
    }

    private void readData() {
        Exception ex1 = null;
        Exception ex2 = null;
        try {
            this.log.info((Object)"Read main store");
            this.queueData = this.readQueueFromFile(this.mainFile);
            if (this.queueData != null) {
                this.log.info((Object)"Success");
            } else {
                this.log.info((Object)"Store have no data");
            }
        }
        catch (Exception ex) {
            this.log.info((Object)("Error on read main store: " + ex.getMessage()));
            ex1 = ex;
        }
        if (this.queueData == null) {
            try {
                this.log.info((Object)"Read secondary store");
                this.queueData = this.readQueueFromFile(this.tmpFile);
                if (this.queueData != null) {
                    this.log.info((Object)"Success");
                } else {
                    this.log.info((Object)"Store have no data");
                }
            }
            catch (Exception ex) {
                this.log.info((Object)("Error on read secondary store: " + ex.getMessage()));
                ex2 = ex;
            }
        }
        if (this.queueData == null) {
            this.queueData = new QueueData();
        } else {
            this.log.info((Object)"===========================================================");
            this.log.info((Object)("Store contains: " + this.queueData));
            this.log.info((Object)"===========================================================");
        }
        if (ex1 != null || ex2 != null) {
            this.putEvent(new Event(EventType.SoftwareFault, (ex1 == null ? "" : ex1) + (ex2 == null ? "" : " " + ex2)));
        }
    }

    private boolean saveData() {
        try {
            this.log.info((Object)"\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u044e \u043f\u0440\u0435\u0434\u0432\u0430\u0440\u0438\u0442\u0435\u043b\u044c\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e");
            SignedObject sign = QueueUtils.signQueue(this.queueData, this.keyStore, this.log);
            if (sign != null) {
                this.tmpFile.writeObject((Serializable)sign);
            } else {
                this.tmpFile.writeObject((Serializable)this.queueData);
            }
            this.log.info((Object)"\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u044e \u043e\u0441\u043d\u043e\u0432\u043d\u0443\u044e \u043a\u043e\u043f\u0438\u044e");
            if (sign != null) {
                this.mainFile.writeObject((Serializable)sign);
            } else {
                this.mainFile.writeObject((Serializable)this.queueData);
            }
        }
        catch (Exception ex) {
            this.diskError = true;
            if (this.listener != null) {
                this.listener.onDiskError();
            }
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445: ", (Throwable)ex);
            return false;
        }
        return true;
    }

    public void close() {
        if (this.mainFile != null) {
            try {
                this.mainFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.tmpFile != null) {
            try {
                this.tmpFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printFileSize(String name) {
        File f = new File(name);
        if (f.canRead()) {
            this.log.info((Object)(f.getAbsolutePath() + ", size=" + f.length()));
        } else {
            this.log.info((Object)(f.getAbsolutePath() + ", n/a"));
        }
    }

    private QueueData readQueueFromFile(ObjectReadWriteStream orwStream) throws IOException, ClassNotFoundException {
        QueueData queue = null;
        Object readObject = orwStream.readObject();
        if (readObject instanceof QueueData) {
            this.log.info((Object)"Queue not signed");
            queue = (QueueData)readObject;
        } else if (readObject instanceof SignedObject) {
            this.log.info((Object)"Queue signed");
            SignedObject signed = (SignedObject)readObject;
            queue = (QueueData)signed.getObject();
            if (!QueueUtils.verifyQueue(signed, this.keyStore, this.log)) {
                this.log.info((Object)"Error verifying signature of queue");
                for (Serializable obj : queue.getFinancialQueue()) {
                    if (!(obj instanceof Operation)) continue;
                    Operation op = (Operation)obj;
                    int flag = op.getFlags();
                    op.setFlags(flag | 0x40);
                }
            } else {
                this.log.info((Object)"Queue signature verification is successful");
            }
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getKeyStore() {
        FileInputStream fis = null;
        try {
            KeyStore ks = KeyStore.getInstance("JCEKS");
            InputStream in = this.getClass().getResourceAsStream("keystore.jks");
            ks.load(in, "softlogic".toCharArray());
            this.log.info((Object)("Key store:" + ks));
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception ex) {
            this.log.info((Object)("KeyStore load error. Reason: " + ex.getMessage()));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    private <T> T[] getFirstEntries(Class<T> clazz) {
        LinkedList<Serializable> mcs = null;
        if (!this.queueData.getFinancialQueue().isEmpty()) {
            mcs = new LinkedList<Serializable>();
            for (Serializable obj : this.queueData.getFinancialQueue()) {
                if (!obj.getClass().equals(clazz)) break;
                mcs.add(obj);
            }
        }
        return mcs == null || mcs.isEmpty() ? null : mcs.toArray((Object[])Array.newInstance(clazz, mcs.size()));
    }
}

