/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.connector.ws.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.cash.unit.CashUnitGroup;
import ru.softlogic.cash.unit.CashUnitProfile;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.reference.fraud.FraudControlRule;
import ru.softlogic.srv.connector.ws.stub.CashUnitGroupStub;
import ru.softlogic.srv.connector.ws.stub.CashUnitProfileStub;
import ru.softlogic.srv.connector.ws.stub.CashUnitStub;
import ru.softlogic.srv.connector.ws.stub.FraudControlRuleStub;

public class WSUtils {
    private static final String FLAG_KEY_IE = "f";
    public static final String defaultNamespace = "http://soft-logic.ru";
    public static final String cpw = "QZt64WK8Vdxq";

    private WSUtils() {
    }

    public static String nodeToString(Node node) {
        return WSUtils.nodeToStringWithMasking(node, WSUtils.createKeysForIE(), WSUtils.createRemovingKeysForIE(), FLAG_KEY_IE, 2048);
    }

    public static String nodeToSign(Node node) {
        NodeList nl;
        Element e;
        NamedNodeMap nnm;
        StringBuilder sb = new StringBuilder(node.getLocalName());
        if (node instanceof Element && (nnm = (e = (Element)node).getAttributes()) != null && nnm.getLength() > 0) {
            for (int i = 0; i < nnm.getLength(); ++i) {
                Node a = nnm.item(i);
                if (a.getNodeName().startsWith("xmlns")) continue;
                sb.append(a.getNodeName()).append(a.getNodeValue());
            }
        }
        if ((nl = node.getChildNodes()) != null && nl.getLength() > 0) {
            int i;
            for (i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (!(n instanceof Text)) continue;
                sb.append(((Text)n).getWholeText());
                break;
            }
            for (i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                if (!(n instanceof Element)) continue;
                sb.append(WSUtils.nodeToSign(n));
            }
        }
        return sb.toString().replace("\r", "").replace("\n", "");
    }

    private static List<String> createKeysForIE() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("key");
        keys.add("value");
        return keys;
    }

    private static List<String> createRemovingKeysForIE() {
        ArrayList<String> removingKeys = new ArrayList<String>();
        removingKeys.add("origin");
        removingKeys.add("value");
        removingKeys.add("valueT");
        return removingKeys;
    }

    private static String nodeToStringWithMasking(Node node, List<String> keys, List<String> removingKeys, String flagKey, int flag) {
        NodeList childs;
        StringBuilder xml = new StringBuilder();
        boolean isNullName = false;
        if (node.getLocalName() != null && !node.getLocalName().isEmpty()) {
            xml.append("<").append(node.getLocalName());
        } else {
            isNullName = true;
        }
        NamedNodeMap childAttrs = node.getAttributes();
        boolean needMasking = false;
        if (childAttrs != null && childAttrs.getLength() > 0) {
            xml.append(" ");
            if (childAttrs.getLength() >= keys.size()) {
                int count = 0;
                if (flagKey != null && childAttrs.getNamedItem(flagKey) != null) {
                    for (String key : keys) {
                        if (childAttrs.getNamedItem(key) == null) continue;
                        ++count;
                    }
                }
                if (count == keys.size()) {
                    Node flagNode = flagKey != null ? childAttrs.getNamedItem(flagKey) : null;
                    needMasking = flagNode != null && (Integer.valueOf(flagNode.getNodeValue()) & flag) != 0;
                }
            }
            for (int i = 0; i < childAttrs.getLength(); ++i) {
                Node attr = childAttrs.item(i);
                if (attr != null) {
                    xml.append(attr.getLocalName()).append("=");
                    String value = attr.getNodeValue();
                    if (needMasking) {
                        for (String removingKey : removingKeys) {
                            if (!attr.getLocalName().equals(removingKey)) continue;
                            value = "";
                            break;
                        }
                    }
                    xml.append("\"").append(value).append("\"");
                }
                if (i == childAttrs.getLength() - 1) {
                    xml.append(">");
                    continue;
                }
                xml.append(" ");
            }
        } else if (!isNullName) {
            xml.append(">");
        }
        if ((childs = node.getChildNodes()) != null && childs.getLength() > 0) {
            for (int i = 0; i < childs.getLength(); ++i) {
                xml.append(WSUtils.nodeToStringWithMasking(childs.item(i), keys, removingKeys, flagKey, flag));
            }
        }
        if (!isNullName) {
            String nodeValue;
            String string = nodeValue = node.getFirstChild() != null ? node.getFirstChild().getNodeValue() : null;
            if (nodeValue != null && !nodeValue.isEmpty()) {
                xml.append(nodeValue);
            }
            xml.append("</").append(node.getLocalName()).append(">");
        }
        return xml.toString();
    }

    public static CashUnitProfile convert(CashUnitProfileStub src) {
        if (src == null) {
            return null;
        }
        CashUnitProfile res = new CashUnitProfile();
        res.setCurrency(src.getCurrency());
        res.setFlags(src.getFlags());
        res.setId(src.getId());
        res.setName(src.getName());
        if (src.getCashUnitGroups() != null) {
            CashUnitGroupStub[] grps = src.getCashUnitGroups();
            CashUnitGroup[] grp = new CashUnitGroup[src.getCashUnitGroups().length];
            for (int i = 0; i < grps.length; ++i) {
                grp[i] = WSUtils.convert(grps[i]);
            }
            res.setCashUnitGroups(grp);
        }
        return res;
    }

    public static CashUnit convert(CashUnitStub src) {
        if (src == null) {
            return null;
        }
        return new CashUnit(src.getId(), src.getNominal(), src.getType());
    }

    public static CashUnitGroup convert(CashUnitGroupStub src) {
        if (src == null) {
            return null;
        }
        CashUnitGroup res = new CashUnitGroup();
        res.setCashUnit(WSUtils.convert(src.getCashUnit()));
        res.setEnable(src.isEnable());
        res.setSecure(src.isSecure());
        res.setEndTime(src.getEndTime());
        res.setStartTime(src.getStartTime());
        return res;
    }

    public static List<FraudControlRule> convert(List<FraudControlRuleStub> src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ArrayList<FraudControlRule> res = new ArrayList<FraudControlRule>();
        for (FraudControlRuleStub fcrs : src) {
            FraudControlRule fcr = new FraudControlRule();
            fcr.setHardwareDetection(fcrs.isHardwareDetection());
            fcr.setHeuristicAnalysis(fcrs.isHeuristicAnalysis());
            fcr.setIdService(fcrs.getIdService());
            fcr.setMinNominalNote(fcrs.getMinNominalNote());
            fcr.setOptionalSuccess(fcrs.isOptionalSuccess());
            fcr.setRejectKol(fcrs.getRejectKol());
            fcr.setSendTimeout(fcrs.getSendTimeout());
            fcr.setTimeout(fcrs.getTimeout());
            res.add(fcr);
        }
        return res;
    }

    public static Map<String, ru.softlogic.srv.connector.ws.stub.advanced.InputElement> convert(Map<String, InputElement> src) {
        if (src == null) {
            return null;
        }
        LinkedHashMap<String, ru.softlogic.srv.connector.ws.stub.advanced.InputElement> res = new LinkedHashMap<String, ru.softlogic.srv.connector.ws.stub.advanced.InputElement>();
        for (Map.Entry<String, InputElement> e : src.entrySet()) {
            res.put(e.getKey(), WSUtils.convert(e.getValue()));
        }
        return res;
    }

    public static ru.softlogic.srv.connector.ws.stub.advanced.InputElement convert(InputElement src) {
        ru.softlogic.srv.connector.ws.stub.advanced.InputElement res = new ru.softlogic.srv.connector.ws.stub.advanced.InputElement();
        res.setKey(src.getKey());
        res.setKeyTitle(src.getKeyTitle());
        res.setOriginalValue(src.getOriginalValue());
        res.setValue(src.getValue());
        res.setValueTitle(src.getValueTitle());
        res.setFlags(src.getFlags());
        return res;
    }

    public static InputElement convert(ru.softlogic.srv.connector.ws.stub.advanced.InputElement src) {
        InputElement res = new InputElement();
        res.setKey(src.getKey());
        res.setKeyTitle(src.getKeyTitle());
        res.setOriginalValue(src.getOriginalValue());
        res.setValue(src.getValue());
        res.setValueTitle(src.getValueTitle());
        res.setFlags(src.getFlags() == null ? 0 : src.getFlags());
        return res;
    }

    public static List<ru.softlogic.srv.connector.ws.stub.advanced.InputElement> inputElementsToStub(Map<String, InputElement> inputElements) {
        if (inputElements == null) {
            return null;
        }
        LinkedList<ru.softlogic.srv.connector.ws.stub.advanced.InputElement> l = new LinkedList<ru.softlogic.srv.connector.ws.stub.advanced.InputElement>();
        for (Map.Entry<String, InputElement> ies : inputElements.entrySet()) {
            ru.softlogic.srv.connector.ws.stub.advanced.InputElement e = new ru.softlogic.srv.connector.ws.stub.advanced.InputElement();
            InputElement ie = ies.getValue();
            e.setKey(WSUtils.clearTabs(ie.getKey()));
            e.setKeyTitle(WSUtils.clearTabs(ie.getKeyTitle()));
            e.setOriginalValue(WSUtils.clearTabs(ie.getOriginalValue()));
            e.setValue(WSUtils.clearTabs(ie.getValue()));
            e.setValueTitle(WSUtils.clearTabs(ie.getValueTitle()));
            e.setFlags(ie.getFlags());
            l.add(e);
        }
        return l;
    }

    private static String clearTabs(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s.replace("\t", "").replace("\r", "").replace("\n", "");
    }

    public static Map<String, InputElement> stubToInputElements(List<ru.softlogic.srv.connector.ws.stub.advanced.InputElement> inputElements) {
        if (inputElements == null) {
            return null;
        }
        LinkedHashMap<String, InputElement> m = new LinkedHashMap<String, InputElement>();
        for (ru.softlogic.srv.connector.ws.stub.advanced.InputElement ie : inputElements) {
            InputElement e = new InputElement();
            e.setKey(ie.getKey());
            e.setKeyTitle(ie.getKeyTitle());
            e.setOriginalValue(ie.getOriginalValue());
            e.setValue(ie.getValue());
            e.setValueTitle(ie.getValueTitle());
            e.setFlags(ie.getFlags() == null ? 0 : ie.getFlags());
            m.put(e.getKey(), e);
        }
        return m;
    }
}

