/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.connector.ws;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.app.state.TerminalState;
import ru.softlogic.cash.Keeper;
import ru.softlogic.cash.Sum;
import ru.softlogic.cash.unit.CashBackCard;
import ru.softlogic.cash.unit.CashUnit;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceInfo;
import ru.softlogic.hardware.device.cashin.MoneyCollection;
import ru.softlogic.hardware.device.cashin.validator.statistics.Statistics;
import ru.softlogic.input.model.FeeSum;
import ru.softlogic.input.model.NestedData;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.advanced.actions.request.Response;
import ru.softlogic.operation.ChildOperation;
import ru.softlogic.operation.GroupOperation;
import ru.softlogic.operation.Operation;
import ru.softlogic.operation.OperationState;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.adv.AdvStatistic;
import ru.softlogic.reference.adv.AdvStatisticRequest;
import ru.softlogic.reference.menu.Menu;
import ru.softlogic.reference.menu.MenuGroupKey;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.point.BINList;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.reference.point.TransportType;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.srv.api.card.CardCover;
import ru.softlogic.srv.api.card.CardOperation;
import ru.softlogic.srv.api.card.SaleConfirm;
import ru.softlogic.srv.api.cbc.ActivationResult;
import ru.softlogic.srv.api.cbc.CbcStatus;
import ru.softlogic.srv.api.command.CommandResult;
import ru.softlogic.srv.api.communal.Calculation;
import ru.softlogic.srv.api.communal.PayerId;
import ru.softlogic.srv.api.communal.PayerResponse;
import ru.softlogic.srv.api.event.Event;
import ru.softlogic.srv.api.iface.NetworkDevice;
import ru.softlogic.srv.api.modem.ModemState;
import ru.softlogic.srv.api.network.NetworkStatistics;
import ru.softlogic.srv.api.network.NetworkStatisticsRequest;
import ru.softlogic.srv.api.operation.ProcessingResult;
import ru.softlogic.srv.api.oth.Demand;
import ru.softlogic.srv.api.oth.FindOperationResult;
import ru.softlogic.srv.api.oth.JammInfo;
import ru.softlogic.srv.api.oth.SystemInfo;
import ru.softlogic.srv.api.refs.References;
import ru.softlogic.srv.api.request.RequestResult;
import ru.softlogic.srv.api.security.EnvRiskFactors;
import ru.softlogic.srv.api.status.DeviceStatus;
import ru.softlogic.srv.api.verify.VerifyResult;
import ru.softlogic.srv.connector.AppStateWatcher;
import ru.softlogic.srv.connector.ConnectorConfiguration;
import ru.softlogic.srv.connector.ConnectorConfigurationException;
import ru.softlogic.srv.connector.ConnectorException;
import ru.softlogic.srv.connector.ProxyConfiguration;
import ru.softlogic.srv.connector.ServerAddress;
import ru.softlogic.srv.connector.ServerInterface;
import ru.softlogic.srv.connector.ZReportInfo;
import ru.softlogic.srv.connector.selector.AddressSelector;
import ru.softlogic.srv.connector.ws.BusinessService;
import ru.softlogic.srv.connector.ws.BusinessServiceService;
import ru.softlogic.srv.connector.ws.security.BasicSecurityException;
import ru.softlogic.srv.connector.ws.security.SSLSocketFactory;
import ru.softlogic.srv.connector.ws.security.SecurityHandler;
import ru.softlogic.srv.connector.ws.security.SignatureAuth;
import ru.softlogic.srv.connector.ws.stub.ActivationRequest;
import ru.softlogic.srv.connector.ws.stub.BINListStub;
import ru.softlogic.srv.connector.ws.stub.BonusRequest;
import ru.softlogic.srv.connector.ws.stub.BonusResult;
import ru.softlogic.srv.connector.ws.stub.BoxAmount;
import ru.softlogic.srv.connector.ws.stub.BoxAmountRequest;
import ru.softlogic.srv.connector.ws.stub.BoxInfo;
import ru.softlogic.srv.connector.ws.stub.BoxInfoRequest;
import ru.softlogic.srv.connector.ws.stub.BoxStatus;
import ru.softlogic.srv.connector.ws.stub.BoxStatusRequest;
import ru.softlogic.srv.connector.ws.stub.CardGoodsResponse;
import ru.softlogic.srv.connector.ws.stub.CardRequest;
import ru.softlogic.srv.connector.ws.stub.CashBackCardStub;
import ru.softlogic.srv.connector.ws.stub.CashUnitStub;
import ru.softlogic.srv.connector.ws.stub.CbcStatusRequest;
import ru.softlogic.srv.connector.ws.stub.CheckCopyRequest;
import ru.softlogic.srv.connector.ws.stub.ChildOperationStub;
import ru.softlogic.srv.connector.ws.stub.ClientPaymentRequest;
import ru.softlogic.srv.connector.ws.stub.CommandResultRequest;
import ru.softlogic.srv.connector.ws.stub.DemandRequest;
import ru.softlogic.srv.connector.ws.stub.DeviceInfoRequest;
import ru.softlogic.srv.connector.ws.stub.DeviceInfoStub;
import ru.softlogic.srv.connector.ws.stub.DeviceStatusRequest;
import ru.softlogic.srv.connector.ws.stub.EncashmentResult;
import ru.softlogic.srv.connector.ws.stub.EventRequest;
import ru.softlogic.srv.connector.ws.stub.FindOperationRequest;
import ru.softlogic.srv.connector.ws.stub.GroupOperationRequest;
import ru.softlogic.srv.connector.ws.stub.GroupOperationStub;
import ru.softlogic.srv.connector.ws.stub.JammRequest;
import ru.softlogic.srv.connector.ws.stub.KeeperStub;
import ru.softlogic.srv.connector.ws.stub.MenuGroupKeyStub;
import ru.softlogic.srv.connector.ws.stub.MenuItemStub;
import ru.softlogic.srv.connector.ws.stub.MenuStub;
import ru.softlogic.srv.connector.ws.stub.MoneyCollectionRequest;
import ru.softlogic.srv.connector.ws.stub.MoneyCollectionResponse;
import ru.softlogic.srv.connector.ws.stub.MoneyCollectionStub;
import ru.softlogic.srv.connector.ws.stub.NetworkDeviceRequest;
import ru.softlogic.srv.connector.ws.stub.OperationCopy;
import ru.softlogic.srv.connector.ws.stub.OperationCopyResult;
import ru.softlogic.srv.connector.ws.stub.OperationRequest;
import ru.softlogic.srv.connector.ws.stub.OperationResult;
import ru.softlogic.srv.connector.ws.stub.OperationStub;
import ru.softlogic.srv.connector.ws.stub.PackageHeader;
import ru.softlogic.srv.connector.ws.stub.PayerRequest;
import ru.softlogic.srv.connector.ws.stub.PointOptionsStub;
import ru.softlogic.srv.connector.ws.stub.ReferencesStub;
import ru.softlogic.srv.connector.ws.stub.RequestStub;
import ru.softlogic.srv.connector.ws.stub.SalesConfirmRequest;
import ru.softlogic.srv.connector.ws.stub.SalesConfirmStub;
import ru.softlogic.srv.connector.ws.stub.ServiceTypeStub;
import ru.softlogic.srv.connector.ws.stub.StatisticsRequest;
import ru.softlogic.srv.connector.ws.stub.SystemInfoRequest;
import ru.softlogic.srv.connector.ws.stub.UpdateState;
import ru.softlogic.srv.connector.ws.stub.VerifyRequest;
import ru.softlogic.srv.connector.ws.stub.ZReportInfoRequest;
import ru.softlogic.srv.connector.ws.stub.advanced.AdvancedResponse;
import ru.softlogic.srv.connector.ws.stub.advanced.Data;
import ru.softlogic.srv.connector.ws.stub.advanced.InputElement;
import ru.softlogic.srv.connector.ws.stub.advanced.RequestData;
import ru.softlogic.srv.connector.ws.util.WSUtils;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;
import ru.softlogic.system.util.network.EasySSL;

public class WSConnector
extends ServerInterface {
    private ConnectorConfiguration configuration;
    private ProxyConfiguration proxyConfiguration;
    private SignatureAuth auth;
    private Logger log = Logger.getLogger((String)"net");
    private int point;
    private AddressSelector<ServerAddress> addressSelector;
    private static final String PATH = "/ws2/BusinessService";
    private static final String IMAGE_PATH = "/server/simages?img=";
    private static final String FILE_PATH = "/server/sfiles?file=";
    private PasswordAuthentication proxyAuth;
    private boolean useHttpsPing;
    private AppStateWatcher stateWatcher;
    public static final String tmp = "/u3+7QAAAAIAAAABAAAAAgANc29mdCBsb2dpYyBjYQAAARtN7GFbAAVYLjUwOQAABJYwggSSMIIDeqADAgECAgkAp8csqJnLMqYwDQYJKoZIhvcNAQEFBQAwgYwxCzAJBgNVBAYTAlJVMQ4wDAYDVQQIEwVBbHRhaTEQMA4GA1UEBxMHQmFybmF1bDETMBEGA1UEChMKU29mdCBMb2dpYzELMAkGA1UECxMCSVQxFjAUBgNVBAMTDVNvZnQgTG9naWMgQ0ExITAfBgkqhkiG9w0BCQEWEmluZm9Ac29mdC1sb2dpYy5ydTAeFw0wODA3MjMwMzEzMjlaFw0yODA3MTgwMzEzMjlaMIGMMQswCQYDVQQGEwJSVTEOMAwGA1UECBMFQWx0YWkxEDAOBgNVBAcTB0Jhcm5hdWwxEzARBgNVBAoTClNvZnQgTG9naWMxCzAJBgNVBAsTAklUMRYwFAYDVQQDEw1Tb2Z0IExvZ2ljIENBMSEwHwYJKoZIhvcNAQkBFhJpbmZvQHNvZnQtbG9naWMucnUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDRQmNLYYb5bdexVYNxvTTQxtGoD3InQWII0nyQlwrb+KY0UxQ5sCR7AfCpzuJv/0bs7ONgwfKOXsnj6qwfNSyRIaPQeZ968p1LnFHpvGVcYZnPEDG9A2KlzG4fYZnA+sHXi/shHuJLGErKPFT9Fz4u0dLEURnGlwEN7wvpOMoillS1R8B76tOqv0u3jbNuK+BV9QSDZ+lq5kN+HjqYlZjNnA3Zp/Rz9LGoyq3qEz1X8oWCFeH4mffC6lCNdB8+wwh1ajjso1Gmlqv30yxlFGkAMTMTvv4QgLVgSyNQaDIvgo3FvOD5O4fXotN4lfCRWc5mbVFzTYwZ3/0NkURcfnoXAgMBAAGjgfQwgfEwHQYDVR0OBBYEFGjzUaj8TsLWC3Q7yMACYFnOW5BAMIHBBgNVHSMEgbkwgbaAFGjzUaj8TsLWC3Q7yMACYFnOW5BAoYGSpIGPMIGMMQswCQYDVQQGEwJSVTEOMAwGA1UECBMFQWx0YWkxEDAOBgNVBAcTB0Jhcm5hdWwxEzARBgNVBAoTClNvZnQgTG9naWMxCzAJBgNVBAsTAklUMRYwFAYDVQQDEw1Tb2Z0IExvZ2ljIENBMSEwHwYJKoZIhvcNAQkBFhJpbmZvQHNvZnQtbG9naWMucnWCCQCnxyyomcsypjAMBgNVHRMEBTADAQH/MA0GCSqGSIb3DQEBBQUAA4IBAQCyrTuMvWTtrLMkiuTnpGmFeLt/O3QtJpmKLGzGyY4Cb9XoOSx+PL259cvvYCv51+47q1NjhVE/k4mLTh444h9+7P6k6pvNewNmzAXxEUhO44yi/swAiNc4h26GLz/MqOZyYmiglKVXWLcgtHBukwWcTkU7SMWV5vUiJCBvU4lMpbfuuY15x7+S1H2VQ4t8Ph5lIsxWYLn+OL9IzH5lAtgbS6YS+gNMWW8QjtMjgTVPgkOtfV8x1i2fU/X3EPeiwlhH1URVRCd9DNjaXjMGWaydKIqb8VIzQ0P/OTmdlvKz9Vx+XvK2qACphN2i+WbL4l+R2L6iKZumr3dWbquDotZGENMMz4Og0SqQQTEkEwvdY0pY1uo=";

    public WSConnector(ConnectorConfiguration configuration, ProxyConfiguration proxy, AppStateWatcher stateWatcher) throws ConnectorConfigurationException {
        this.log.setAdditivity(false);
        this.configuration = configuration;
        this.proxyConfiguration = proxy;
        this.stateWatcher = stateWatcher;
        this.addressSelector = new AddressSelector();
        if (configuration == null) {
            throw new ConnectorConfigurationException("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
        }
        if (proxy == null) {
            throw new ConnectorConfigurationException("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f proxy \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
        }
        if (configuration.getParams().get("point") == null) {
            throw new ConnectorConfigurationException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043d\u043e\u043c\u0435\u0440 \u0442\u043e\u0447\u043a\u0438!");
        }
        if (stateWatcher == null) {
            throw new ConnectorConfigurationException("StateWatcher \u043d\u0435 \u0437\u0430\u0434\u0430\u043d");
        }
        this.log.info((Object)("proxy111=" + SystemProp.getHttpProxyHost()));
        System.setProperty("proxySet", "false");
        System.getProperties().remove("http.proxyHost");
        System.getProperties().remove("https.proxyHost");
        System.getProperties().remove("http.proxyPort");
        System.getProperties().remove("https.proxyPort");
        this.log.info((Object)("proxy=" + proxy));
        if (proxy.isUseProxy() && proxy.getProxyHost() != null && proxy.getProxyPort() != null) {
            System.setProperty("proxySet", "true");
            System.setProperty("http.proxyHost", proxy.getProxyHost());
            System.setProperty("https.proxyHost", proxy.getProxyHost());
            System.setProperty("http.proxyPort", proxy.getProxyPort());
            System.setProperty("https.proxyPort", proxy.getProxyPort());
            if (this.proxyConfiguration.isAuthProxy() && this.proxyConfiguration.getProxyUser() != null && this.proxyConfiguration.getProxyPassword() != null) {
                this.proxyAuth = new PasswordAuthentication(proxy.getProxyUser(), proxy.getProxyPassword().toCharArray());
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                            return WSConnector.this.proxyAuth;
                        }
                        return null;
                    }
                });
            }
        }
        try {
            this.point = Integer.parseInt(configuration.getParams().get("point"));
        }
        catch (Exception e) {
            throw new ConnectorConfigurationException("\u041d\u0435 \u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u043d\u043e\u043c\u0435\u0440\u0430 \u0442\u043e\u0447\u043a\u0438!");
        }
        if (configuration.getParams().get("private-key") == null || configuration.getParams().get("public-key") == null) {
            throw new ConnectorConfigurationException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043a\u043b\u044e\u0447\u0438 \u0434\u043b\u044f \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f!");
        }
        String priv = null;
        String pub = null;
        try {
            priv = FileUtil.readFile((File)new File(configuration.getParams().get("private-key")));
            pub = FileUtil.readFile((File)new File(configuration.getParams().get("public-key")));
        }
        catch (Exception ex) {
            throw new ConnectorConfigurationException(ex);
        }
        try {
            this.auth = new SignatureAuth(priv, pub);
        }
        catch (BasicSecurityException ex) {
            throw new ConnectorConfigurationException(ex);
        }
        ServerAddress[] addresses = null;
        try {
            addresses = ReferenceManager.getInstance().getServerAddresses();
        }
        catch (ReferenceException re) {
            throw new ConnectorConfigurationException(re);
        }
        if (addresses == null || addresses.length == 0) {
            if (configuration.getParams().get("server") == null || configuration.getParams().get("port") == null || configuration.getParams().get("scheme") == null) {
                throw new ConnectorConfigurationException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
            }
            int httpPort = 0;
            try {
                if (configuration.getParams().get("http-port") != null) {
                    httpPort = Integer.parseInt(configuration.getParams().get("http-port"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            addresses = new ServerAddress[]{new ServerAddress(configuration.getParams().get("server"), Integer.parseInt(configuration.getParams().get("port")), httpPort)};
        }
        for (ServerAddress serverAddress : addresses) {
            this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c \u0430\u0434\u0440\u0435\u0441 : " + serverAddress));
            this.addressSelector.addAddress(serverAddress);
        }
        if (configuration.getParams().get("timeout") != null) {
            this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u0430\u0439\u043c\u0430\u0443\u0442 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f : " + configuration.getParams().get("timeout")));
            System.setProperty("sun.net.client.defaultConnectTimeout", configuration.getParams().get("timeout"));
            System.setProperty("sun.net.client.defaultReadTimeout", configuration.getParams().get("timeout"));
        }
    }

    private BusinessService getBusinessService(ServerAddress serverAddress, String scheme) throws ConnectorException {
        SecurityHandler handler = new SecurityHandler(this.auth);
        BusinessServiceService serviceFactory = new BusinessServiceService(this.getClass().getResource("BusinessService.wsdl"));
        BusinessService service = serviceFactory.getBusinessServicePort();
        List list = ((BindingProvider)service).getBinding().getHandlerChain();
        list.add(handler);
        ((BindingProvider)service).getBinding().setHandlerChain(list);
        if (this.configuration.getParams().get("timeout") != null) {
            ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.connect.timeout", new Integer(this.configuration.getParams().get("timeout")));
            ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.request.timeout", new Integer(this.configuration.getParams().get("timeout")));
            ((BindingProvider)service).getRequestContext().put("com.sun.xml.ws.connect.timeout", new Integer(this.configuration.getParams().get("timeout")));
            ((BindingProvider)service).getRequestContext().put("com.sun.xml.ws.request.timeout", new Integer(this.configuration.getParams().get("timeout")));
            this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0442\u0430\u0439\u043c\u0430\u0443\u0442: " + new Integer(this.configuration.getParams().get("timeout"))));
        }
        HashMap<String, List<String>> httpHeaders = new HashMap<String, List<String>>();
        httpHeaders.put("Accept-Encoding", Collections.singletonList("gzip"));
        httpHeaders.put("Content-Encoding", Collections.singletonList("gzip"));
        if (this.proxyConfiguration.isAuthProxy() && this.proxyConfiguration.getProxyUser() != null && this.proxyConfiguration.getProxyPassword() != null) {
            String encoded = new String(Base64.encodeBase64((byte[])(this.proxyConfiguration.getProxyUser() + ":" + this.proxyConfiguration.getProxyPassword()).getBytes()));
            httpHeaders.put("Proxy-Authorization", Collections.singletonList("Basic " + encoded));
        }
        ((BindingProvider)service).getRequestContext().put("javax.xml.ws.http.request.headers", httpHeaders);
        String s = scheme;
        if (s.equals("http") && serverAddress.getHttpPort() == 0) {
            s = "https";
        }
        int port = serverAddress.getPort();
        if (s.equals("http")) {
            port = serverAddress.getHttpPort();
        }
        if (s.equals("https")) {
            try {
                ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.SSLSocketFactory", SSLSocketFactory.getFactory());
                ((BindingProvider)service).getRequestContext().put("com.sun.xml.internal.ws.transport.https.client.hostname.verifier", SSLSocketFactory.getVerifier());
            }
            catch (BasicSecurityException ex) {
                throw new ConnectorException(ex);
            }
        }
        ((BindingProvider)service).getRequestContext().put("javax.xml.ws.service.endpoint.address", s + "://" + serverAddress.getIp() + ":" + port + PATH);
        this.log.info((Object)("URL \u0434\u043b\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438: " + s + "://" + serverAddress.getIp() + ":" + port + PATH));
        return service;
    }

    @Override
    public boolean sendEvents(Event[] event) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            EventRequest request = new EventRequest();
            request.setEvents(event);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.events(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.notifyStatus(true);
            this.addressSelector.updateState(serverAddress, true);
            this.log.error((Object)("Web service exception, error count " + this.addressSelector.getErrorCount(serverAddress)));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.notifyStatus(true);
            this.addressSelector.updateState(serverAddress, true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendStatuses(DeviceStatus[] deviceStatus) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            DeviceStatusRequest request = new DeviceStatusRequest();
            request.setStatuses(deviceStatus);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.statusesNg(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendDeviceInfo(DeviceInfo[] deviceInfos) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            DeviceInfoRequest request = new DeviceInfoRequest();
            DeviceInfoStub[] stubs = new DeviceInfoStub[deviceInfos.length];
            for (int i = 0; i < deviceInfos.length; ++i) {
                stubs[i] = new DeviceInfoStub(deviceInfos[i].getDeviceClass(), deviceInfos[i].getDeviceType(), deviceInfos[i].getVendor(), deviceInfos[i].getModel(), deviceInfos[i].getSerial(), deviceInfos[i].getPort(), deviceInfos[i].getFirmware(), deviceInfos[i].getFirmware1(), deviceInfos[i].getFirmware2(), deviceInfos[i].getProto(), deviceInfos[i].getInfo(), deviceInfos[i].isHasUpdate(), deviceInfos[i].getUpdateInfo());
            }
            request.setDeviceInfos(stubs);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.infosNg(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendMoneyCollection(MoneyCollection[] moneyCollection) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            MoneyCollectionRequest request = new MoneyCollectionRequest();
            MoneyCollectionStub[] stubs = new MoneyCollectionStub[moneyCollection.length];
            for (int i = 0; i < moneyCollection.length; ++i) {
                KeeperStub keeper = new KeeperStub();
                List<CashBackCardStub> cbcStubs = keeper.getCashBackCards();
                Map<CashUnitStub, Integer> cuStubs = keeper.getCashUnits();
                keeper.setSum(moneyCollection[i].getKeeper().getSum());
                for (CashBackCard cbc : moneyCollection[i].getKeeper().getCashBackCards()) {
                    cbcStubs.add(new CashBackCardStub(cbc.getNominal(), cbc.getId(), cbc.getRef()));
                }
                for (CashUnit cu : moneyCollection[i].getKeeper().getCashUnits().keySet()) {
                    cuStubs.put(new CashUnitStub(cu.getNominal(), cu.getId(), cu.getType()), (Integer)moneyCollection[i].getKeeper().getCashUnits().get(cu));
                }
                stubs[i] = new MoneyCollectionStub(moneyCollection[i].getId(), moneyCollection[i].getDate(), moneyCollection[i].getDeviceClass().getCode(), moneyCollection[i].getMenuUser() == null ? null : Short.valueOf(moneyCollection[i].getMenuUser().getId()), keeper);
                stubs[i].setPayout(moneyCollection[i].isPayout());
            }
            request.setMoneyCollections(stubs);
            Holder holder = new Holder((Object)header);
            BusinessService service = this.getBusinessService(serverAddress, "https");
            boolean result = service.moneyCollectionNg(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendStatistics(Statistics[] statistics) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            StatisticsRequest request = new StatisticsRequest();
            request.setStatistics(statistics);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.statisticsNg(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendAdvStatistics(AdvStatistic[] statistics) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            AdvStatisticRequest request = new AdvStatisticRequest();
            request.setStatistics(statistics);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.advStatistic(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean process(Operation[] operations) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            OperationRequest request = new OperationRequest();
            OperationStub[] stubs = new OperationStub[operations.length];
            for (int i = 0; i < operations.length; ++i) {
                stubs[i] = this.getOperationStub(operations[i]);
            }
            request.setOperations(stubs);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.operations(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public OperationState[] processWithResult(Operation[] operations) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            OperationRequest request = new OperationRequest();
            OperationStub[] stubs = new OperationStub[operations.length];
            for (int i = 0; i < operations.length; ++i) {
                stubs[i] = this.getOperationStub(operations[i]);
            }
            request.setOperations(stubs);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            OperationResult result = service.operationsWithResult(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result.getResults() == null ? new OperationState[]{} : result.getResults();
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ProcessingResult process(Operation operation) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            OperationStub request = this.getOperationStub(operation);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            ProcessingResult result = service.operation(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public ActivationResult acivateCashBackCard(String pin, Sum sum, Sum maxSum, int activationNumber) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            ActivationRequest request = new ActivationRequest(pin, sum, maxSum, activationNumber);
            Holder holder = new Holder((Object)header);
            BusinessService service = this.getBusinessService(serverAddress, "https");
            ActivationResult result = service.activation(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public VerifyResult verify(Service s, Map<String, ru.softlogic.input.model.InputElement> data) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            VerifyRequest request = new VerifyRequest();
            request.setElements(WSUtils.convert(data));
            request.setIdService(s.getId());
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            VerifyResult result = service.verify(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public CardCover[] getCardCovers(Service s) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            CardGoodsResponse result = service.cardGoods(s.getId(), (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result.getGoods() == null ? new CardCover[]{} : result.getGoods();
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public CardOperation processCard(Operation payment, CardCover cardCover) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            CardRequest request = new CardRequest(this.getOperationStub(payment), cardCover);
            Holder holder = new Holder((Object)header);
            BusinessService service = this.getBusinessService(serverAddress, "https");
            CardOperation result = service.cards(request, (Holder<PackageHeader>)holder);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.notifyStatus(false);
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean registerSales(SaleConfirm[] confirms) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            SalesConfirmRequest request = new SalesConfirmRequest();
            SalesConfirmStub[] stubs = new SalesConfirmStub[confirms.length];
            for (int i = 0; i < confirms.length; ++i) {
                stubs[i] = new SalesConfirmStub(this.getOperationStub(confirms[i].getOperation()), confirms[i].getCardOperation().getCid());
            }
            request.setConfirms(stubs);
            Holder holder = new Holder((Object)header);
            BusinessService service = this.getBusinessService(serverAddress, "https");
            boolean result = service.registerSales(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public References getReferences() throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            BINListStub binListStub;
            MenuStub menuStub;
            int i;
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            ReferencesStub result = service.references(0, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            References ref = new References();
            ref.setVersion(result.getVersion());
            ref.setDealer(result.getDealer());
            ref.setPoint(result.getPoint());
            ref.setServiceOptions(result.getServiceOptions());
            ref.setMenuItemStates(result.getMenuItemStates());
            ref.setBanners(result.getBanners());
            ref.setMovies(result.getMovies());
            ref.setPromos(result.getPromo());
            ref.setBonuses(result.getBonus());
            ref.setCheckAdvs(result.getCheckAdvs());
            ref.setCommands(result.getCommands());
            ref.setAuth(result.getAuth());
            if (ref.getAuth() != null && ref.getAuth().getEmailSettings() != null) {
                ref.getAuth().setEmailSettings(ref.getAuth().getEmailSettings().replace("\\n", "\n"));
            }
            ref.setUpdateOptions(result.getUpdateOptions());
            ref.setBank(result.getBank());
            ref.setPaymentSystem(result.getPaymentSystem());
            ref.setServerAddresses(result.getServerAddresses());
            ref.setServerUsers(result.getSecretMenuUsers());
            ref.setCurrencyRates(result.getCurrencyRates());
            ref.setProviderCurrencyRates(result.getProviderCurrencyRates());
            ref.setWeather(result.getWeather());
            ref.setFraudControlRules(WSUtils.convert(result.getFraudControlRules()));
            ref.setEncashments(result.getEncashments());
            if (result.getPointOptions() != null) {
                CashUnit[] units;
                PointOptionsStub pos = result.getPointOptions();
                CashUnitStub[] stubs = pos.getUnits();
                if (stubs != null && stubs.length > 0) {
                    units = new CashUnit[stubs.length];
                    for (i = 0; i < stubs.length; ++i) {
                        units[i] = new CashUnit(stubs[i].getId(), stubs[i].getNominal(), stubs[i].getType());
                    }
                } else {
                    units = new CashUnit[]{};
                }
                ref.setPointOptions(new PointOptions(pos.getQueueSize(), pos.getQueueTimeout(), pos.getQueueScanTimeout(), pos.isPlaySound(), units, pos.isShowCommission(), pos.isShowOutcome(), pos.isPaperWarning(), pos.getTransportType()));
                ref.getPointOptions().setBalanceTimeout(pos.getBalanceTimeout());
                ref.getPointOptions().setUseNightMode(pos.isUseNightMode());
                ref.getPointOptions().setLanguage(pos.getLanguage());
                ref.getPointOptions().setLanguages(pos.getLanguages());
                ref.getPointOptions().setCollectionStrategy(pos.getCollectionStrategy());
                ref.getPointOptions().setCollectionStrategy2(pos.getCollectionStrategy2());
                ref.getPointOptions().setWorkWithBrokenFiscal(pos.isWorkWithBrokenFiscal());
                ref.getPointOptions().setUseFiscalDepartments(pos.isUseFiscalDepartments());
                ref.getPointOptions().setCheckRender(pos.getCheckRender());
                ref.getPointOptions().setInkassRender(pos.getInkassRender());
                ref.getPointOptions().setDisconnectTimeout(pos.getDisconnectTimeout());
                ref.getPointOptions().setConnectTimeout(pos.getConnectTimeout());
                ref.getPointOptions().setRebootTimeout(pos.getRebootTimeout());
                ref.getPointOptions().setGuiMenuTimeout(pos.getGuiMenuTimeout());
                ref.getPointOptions().setGuiProcessTimeout(pos.getGuiProcessTimeout());
                ref.getPointOptions().setMaxPackageSize(pos.getMaxPackageSize());
                ref.getPointOptions().setShowCashback(pos.isShowCashback());
                ref.getPointOptions().setCheckTouchScreen(pos.isCheckTouchScreen());
                ref.getPointOptions().setPrintZreportWhileBufferIsFull(pos.isPrintZreportWhileBufferIsFull());
                ref.getPointOptions().setPrintZreportWhileBufferIsNotSupported(pos.isPrintZreportWhileBufferIsNotSupported());
                ref.getPointOptions().setChangeCoinLimit(pos.getChangeCoinLimit());
                ref.getPointOptions().setChangeRestLimit(pos.getChangeRestLimit());
                ref.getPointOptions().setChangeRestPercent(Integer.valueOf(pos.getChangeRestPercent()));
                ref.getPointOptions().setNotConnectedMinute(pos.getNotConnectedMinute());
                ref.getPointOptions().setNotConnectedTry(pos.getNotConnectedTry());
                ref.getPointOptions().setNotPaymentRebootTimeout(pos.getNotPaymentRebootTimeout());
                ref.getPointOptions().setLockingActions(pos.getLockingActions());
                ref.getPointOptions().setCashUnitProfile(WSUtils.convert(pos.getCashUnitProfile()));
                ref.getPointOptions().setzReportTimeBlock(pos.getzReportTimeBlock());
                ref.getPointOptions().setzReportTimeCreate(pos.getzReportTimeCreate());
                ref.getPointOptions().setzReportSyncTime(pos.iszReportSyncTime());
            }
            if ((menuStub = result.getMenuItems()) == null) {
                ref.setMenu(null);
            } else {
                Integer flags;
                Menu menu = new Menu();
                menu.setIclass(menuStub.getIclass());
                menu.setIface(menuStub.getIface());
                menu.setMenuDesign(menuStub.getMenuDesign());
                menu.setScreenType(menuStub.getScreenType());
                if (menuStub.getTypes() != null) {
                    ServiceType[] st = new ServiceType[menuStub.getTypes().length];
                    i = 0;
                    for (ServiceTypeStub sts : menuStub.getTypes()) {
                        st[i] = new ServiceType();
                        this.loadChildTypes(st[i], sts);
                        ++i;
                    }
                    menu.setTypes(st);
                }
                if ((flags = menuStub.getFlags()) != null) {
                    menu.setFlags(flags.intValue());
                }
                menu.setAutoassignFreeHotkeys(menuStub.getAutoassignFreeHotkeys());
                ref.setMenu(menu);
            }
            ref.setPersonalNumbers(result.getPersonalNumbers());
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            if (ref.getBanners() != null && ref.getBanners().length > 0) {
                this.notifyBanners(ref.getBanners());
            }
            if (ref.getMovies() != null && ref.getMovies().length > 0) {
                this.notifyBanners(ref.getBanners());
            }
            if (result.getChanged() != null && result.getChanged().length > 0) {
                MenuItem[] changed = new MenuItem[result.getChanged().length];
                for (int j = 0; j < result.getChanged().length; ++j) {
                    MenuItemStub src = result.getChanged()[j];
                    changed[j] = new MenuItem();
                    changed[j].setIdMenuItem(src.getIdMenuItem());
                    changed[j].setCommission(src.getCommission());
                    changed[j].setHotKey(src.isHotKey());
                    changed[j].setHotkeyPosition(src.getHotkeyPosition());
                    changed[j].setVerify(src.isVerify());
                    changed[j].setSpecialButton(src.isSpecialButton());
                    changed[j].setFlags(src.getFlags());
                    changed[j].setSortOrder(src.getSortOrder());
                    changed[j].setService(src.getService());
                    changed[j].setHideUnactive(src.isHideUnactive());
                    if (src.getUnits() != null) {
                        CashUnitStub[] stubs = src.getUnits();
                        CashUnit[] units = new CashUnit[stubs.length];
                        for (int k = 0; k < stubs.length; ++k) {
                            units[k] = new CashUnit(stubs[k].getId(), stubs[k].getNominal(), stubs[k].getType());
                        }
                        changed[j].setUnits(units);
                    }
                    changed[j].setIgnoreMinMaxCommission(src.isIgnoreMinMaxCommission());
                    changed[j].setCashUnitProfile(WSUtils.convert(src.getCashUnitProfile()));
                    changed[j].setRate(src.getRate());
                    changed[j].setScreenType(src.getScreenType());
                    changed[j].setDecor(src.getDecor());
                }
                ref.setChanged(changed);
            }
            if ((binListStub = result.getBinList()) != null) {
                BINList binList = new BINList(binListStub.getIin(), binListStub.getValid(), binListStub.getInvalid(), binListStub.getCapture());
                ref.setBinList(binList);
            }
            this.addressSelector.updateState(serverAddress, false);
            return ref;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    public void loadChildTypes(ServiceType to, ServiceTypeStub from) throws Exception {
        try {
            to.setId(from.getId());
            to.setImage(from.getImage());
            to.setStyle(from.getStyle());
            to.setLangs(from.getLangs());
            to.setName(from.getName());
            to.setHotkeyPosition(from.getHotkeyPosition());
            to.setInvitation(from.getInvitation());
            to.setSortOrder(from.getSortOrder());
            to.setScreenType(from.getScreenType());
            to.setBlocked(from.getBlocked());
            to.setDesc(from.getDesc());
            to.setLabel(from.getLabel());
            to.setHidden(from.getHidden());
            ArrayList<MenuGroupKey> menuGroupKeys = new ArrayList<MenuGroupKey>();
            for (MenuGroupKeyStub mgkStub : from.getMenuGroupKeys()) {
                if (mgkStub == null) continue;
                menuGroupKeys.add(new MenuGroupKey(mgkStub.getIdMenuItem(), mgkStub.getHotkeyPosition()));
            }
            to.setMenuGroupKeys(menuGroupKeys);
            MenuItem[] mItems = new MenuItem[]{};
            if (from.getMenuItems() != null) {
                mItems = new MenuItem[from.getMenuItems().length];
                for (int j = 0; j < mItems.length; ++j) {
                    MenuItemStub menuItemStub = from.getMenuItems()[j];
                    mItems[j] = new MenuItem();
                    mItems[j].setIdMenuItem(menuItemStub.getIdMenuItem());
                    mItems[j].setCommission(menuItemStub.getCommission());
                    mItems[j].setHotKey(menuItemStub.isHotKey());
                    mItems[j].setHotkeyPosition(menuItemStub.getHotkeyPosition());
                    mItems[j].setVerify(menuItemStub.isVerify());
                    mItems[j].setSpecialButton(menuItemStub.isSpecialButton());
                    mItems[j].setFlags(menuItemStub.getFlags());
                    mItems[j].setSortOrder(menuItemStub.getSortOrder());
                    mItems[j].setService(menuItemStub.getService());
                    mItems[j].setSchedules(menuItemStub.getSchedules());
                    mItems[j].setHideUnactive(menuItemStub.isHideUnactive());
                    mItems[j].setScreenType(menuItemStub.getScreenType());
                    mItems[j].setDecor(menuItemStub.getDecor());
                    if (menuItemStub.getUnits() != null) {
                        CashUnitStub[] stubs = menuItemStub.getUnits();
                        CashUnit[] units = new CashUnit[stubs.length];
                        for (int k = 0; k < stubs.length; ++k) {
                            units[k] = new CashUnit(stubs[k].getId(), stubs[k].getNominal(), stubs[k].getType());
                        }
                        mItems[j].setUnits(units);
                    }
                    mItems[j].setIgnoreMinMaxCommission(menuItemStub.isIgnoreMinMaxCommission());
                    mItems[j].setCashUnitProfile(WSUtils.convert(menuItemStub.getCashUnitProfile()));
                    mItems[j].setRate(menuItemStub.getRate());
                }
            }
            to.setMenuItems(mItems);
            ServiceType[] st = new ServiceType[]{};
            if (from.getTypes() != null && from.getTypes().length > 0) {
                st = new ServiceType[from.getTypes().length];
                int i = 0;
                for (ServiceTypeStub sts : from.getTypes()) {
                    st[i] = new ServiceType();
                    this.loadChildTypes(st[i], sts);
                    ++i;
                }
            }
            to.setTypes(st);
        }
        catch (Exception e) {
            this.log.error((Object)"", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Date ping() throws ConnectorException {
        if (!this.useHttpsPing) {
            try {
                return this.ping("http");
            }
            catch (Exception ex) {
                Date date = this.ping("https");
                this.useHttpsPing = true;
                return date;
            }
        }
        return this.ping("https");
    }

    public Date ping(String schema) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            BusinessService service = this.getBusinessService(serverAddress, schema);
            boolean result = service.ping(1, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return ((PackageHeader)holder.value).getServerDate();
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    private OperationStub getOperationStub(Operation operation) {
        OperationStub request = new OperationStub();
        request.setFeHash(operation.getFeHash());
        KeeperStub keeper = new KeeperStub();
        List<CashBackCardStub> cbcStubs = keeper.getCashBackCards();
        Map<CashUnitStub, Integer> cuStubs = keeper.getCashUnits();
        keeper.setSum(operation.getKeeper().getSum());
        for (CashBackCard cbc : operation.getKeeper().getCashBackCards()) {
            cbcStubs.add(new CashBackCardStub(cbc.getNominal(), cbc.getId(), cbc.getRef()));
        }
        for (CashUnit cu : operation.getKeeper().getCashUnits().keySet()) {
            cuStubs.put(new CashUnitStub(cu.getNominal(), cu.getId(), cu.getType()), (Integer)operation.getKeeper().getCashUnits().get(cu));
        }
        if (operation.getChange() != null) {
            KeeperStub change = new KeeperStub();
            cbcStubs = change.getCashBackCards();
            cuStubs = change.getCashUnits();
            change.setSum(operation.getChange().getSum());
            request.setChange(change);
            for (CashBackCard cbc : operation.getChange().getCashBackCards()) {
                cbcStubs.add(new CashBackCardStub(cbc.getNominal(), cbc.getId(), cbc.getRef()));
            }
            for (CashUnit cu : operation.getChange().getCashUnits().keySet()) {
                cuStubs.put(new CashUnitStub(cu.getNominal(), cu.getId(), cu.getType()), (Integer)operation.getChange().getCashUnits().get(cu));
            }
        }
        request.setCheckNumber(operation.getCheckNumber());
        request.setDate(operation.getDate());
        request.setInputElements(WSUtils.inputElementsToStub(operation.getInputElements()));
        request.setPaymentTool(operation.getPaymentTool());
        request.setCashlessData(operation.getCashlessData());
        request.setFlags(operation.getFlags());
        request.setChangeDate(operation.getChangeDate());
        if (operation.getCommission() == null) {
            request.setIdCommission(1);
            this.log.error((Object)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044f");
        } else {
            request.setIdCommission(operation.getCommission().getId());
        }
        request.setIdOperation(operation.getIdOperation());
        request.setIdService(operation.getService().getId());
        request.setKeeper(keeper);
        request.setPinCode(operation.getPinCode());
        request.setPinCodeNominal(operation.getPinCodeNominal());
        request.setSumResult(operation.getSumResult());
        return request;
    }

    @Override
    public void downloadImage(String img, File whereToSave) throws ConnectorException {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(this.configuration.getParams().get("scheme") + "://" + this.configuration.getParams().get("server") + ":" + this.configuration.getParams().get("port") + IMAGE_PATH + img).openConnection();
            FileUtil.writeFile((File)whereToSave, (InputStream)conn.getInputStream());
            conn.disconnect();
            this.notifyStatus(false);
        }
        catch (IOException ex) {
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (FileUtilException ex) {
            throw new ConnectorException(ex);
        }
    }

    @Override
    public void downloadFile(String file, File whereToSave) throws ConnectorException {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(this.configuration.getParams().get("scheme") + "://" + this.configuration.getParams().get("server") + ":" + this.configuration.getParams().get("port") + FILE_PATH + file).openConnection();
            conn.setConnectTimeout(40000);
            if (conn instanceof HttpsURLConnection) {
                EasySSL.makeEasySSL((HttpsURLConnection)((HttpsURLConnection)conn));
            }
            conn.setRequestProperty("Accept-Encoding", "gzip,deflate");
            String encoding = conn.getHeaderField("Content-Encoding");
            InputStream is = conn.getInputStream();
            if (encoding != null && encoding.equals("gzip")) {
                is = new GZIPInputStream(is);
            }
            FileUtil.writeFile((File)whereToSave, (InputStream)is);
            conn.disconnect();
        }
        catch (IOException ex) {
            throw new ConnectorException(ex);
        }
        catch (FileUtilException ex) {
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendModemState(ModemState state) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.modem(state, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendNetworkDevices(NetworkDevice[] devices) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            NetworkDeviceRequest request = new NetworkDeviceRequest();
            request.setDevices(devices);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.networks(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendEncashmentResult(EncashmentResult result) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean res = service.updateEncashmentStatus(result, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return res;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean commandConfirm(CommandResult[] commandResults) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            CommandResultRequest request = new CommandResultRequest();
            for (CommandResult commandResult : commandResults) {
                if (commandResult.getComment() == null) continue;
                commandResult.setComment(commandResult.getComment().replace("\r", "").replace("\n", ""));
            }
            request.setCommands(commandResults);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.commands(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean demand(Demand[] demands) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            DemandRequest request = new DemandRequest();
            request.setDemands(demands);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.demand(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendSpace(int space) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.space(space, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendJamm(JammInfo[] info) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            JammRequest request = new JammRequest();
            request.setInfos(info);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.jamm(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public RequestResult request(Service service, Map<String, ru.softlogic.input.model.InputElement> data) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            RequestStub request = new RequestStub();
            request.setElements(WSUtils.convert(data));
            request.setSid(service.getId());
            Holder holder = new Holder((Object)header);
            BusinessService serv = this.getBusinessService(serverAddress, "https");
            RequestResult result = serv.orequest(request, (Holder<PackageHeader>)holder);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.notifyStatus(false);
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public long getBalance(short idPerson) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            long result = service.balance(idPerson, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public MoneyCollection[] getCollections() throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            MoneyCollectionResponse result = service.getCollectionsNg(1, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            if (result == null || result.getMoneyCollections() == null || result.getMoneyCollections().length == 0) {
                return new MoneyCollection[0];
            }
            MoneyCollection[] res = new MoneyCollection[result.getMoneyCollections().length];
            for (int i = 0; i < res.length; ++i) {
                Keeper k = new Keeper();
                Map<CashUnitStub, Integer> cu = result.getMoneyCollections()[i].getKeeper().getCashUnits();
                for (CashUnitStub cus : cu.keySet()) {
                    CashUnit cahsUnit = new CashUnit(cus.getId(), cus.getNominal(), cus.getType());
                    for (int j = 0; j < cu.get(cus); ++j) {
                        k.addCash(cahsUnit);
                    }
                }
                res[i] = new MoneyCollection(result.getMoneyCollections()[i].getId(), k, DeviceClass.getValueByCode((Short)result.getMoneyCollections()[i].getDeviceClass()), result.getMoneyCollections()[i].getDate(), null);
                res[i].setDate(result.getMoneyCollections()[i].getDate());
            }
            return res;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public FindOperationResult findOperation(Short point, Integer checkNumber, String date, String account, Integer sum) throws ConnectorException {
        FindOperationRequest req = new FindOperationRequest();
        req.setPoint(point);
        req.setAccount(account);
        req.setCheck(checkNumber);
        req.setDate(date);
        req.setSum(sum);
        return this.findOperationRequest(req);
    }

    @Override
    public FindOperationResult findOperationAdv(String bigCheckNumber, String date, String account, Integer sum) throws ConnectorException {
        FindOperationRequest req = new FindOperationRequest();
        req.setBigCheck(bigCheckNumber);
        req.setAccount(account);
        req.setDate(date);
        req.setSum(sum);
        return this.findOperationRequest(req);
    }

    private FindOperationResult findOperationRequest(FindOperationRequest req) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            FindOperationResult result = service.getOperations(req, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public PayerResponse getPayerId(Map<String, String> form) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            BusinessService serv = this.getBusinessService(serverAddress, "https");
            PayerRequest pr = new PayerRequest();
            pr.setForm(form);
            pr.setS(1);
            PayerResponse result = serv.payer(pr, (Holder<PackageHeader>)holder);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.notifyStatus(false);
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public Calculation getCalculations(PayerId payerId) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            BusinessService serv = this.getBusinessService(serverAddress, "https");
            Calculation result = serv.communal(payerId, (Holder<PackageHeader>)holder);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.notifyStatus(false);
            this.addressSelector.updateState(serverAddress, false);
            return result.getServiceGroup() == null ? null : result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean processGroup(GroupOperation[] operations) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            GroupOperationRequest request = new GroupOperationRequest();
            GroupOperationStub[] stubs = new GroupOperationStub[operations.length];
            boolean sslFlag = false;
            for (int i = 0; i < operations.length; ++i) {
                stubs[i] = this.getGroupOperationStub(operations[i]);
                if (stubs[i].getPinCode() == null || stubs[i].getPinCode().isEmpty()) continue;
                sslFlag = true;
            }
            request.setOperations(stubs);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            if (!sslFlag) {
                try {
                    PointOptions po = ReferenceManager.getInstance().getPointOptions();
                    if (po.getTransportType() == TransportType.Http) {
                        scheme = "http";
                    }
                }
                catch (ReferenceException re) {
                    this.log.error((Object)re, (Throwable)re);
                }
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.groupOperations(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    private GroupOperationStub getGroupOperationStub(GroupOperation operation) {
        GroupOperationStub request = new GroupOperationStub();
        request.setFeHash(operation.getFeHash());
        KeeperStub keeper = new KeeperStub();
        List<CashBackCardStub> cbcStubs = keeper.getCashBackCards();
        Map<CashUnitStub, Integer> cuStubs = keeper.getCashUnits();
        keeper.setSum(operation.getKeeper().getSum());
        for (CashBackCard cbc : operation.getKeeper().getCashBackCards()) {
            cbcStubs.add(new CashBackCardStub(cbc.getNominal(), cbc.getId(), cbc.getRef()));
        }
        for (CashUnit cu : operation.getKeeper().getCashUnits().keySet()) {
            cuStubs.put(new CashUnitStub(cu.getNominal(), cu.getId(), cu.getType()), (Integer)operation.getKeeper().getCashUnits().get(cu));
        }
        request.setCheckNumber(operation.getCheckNumber());
        request.setDate(operation.getDate());
        request.setInputElements(WSUtils.inputElementsToStub(operation.getInputElements()));
        if (operation.getCommission() == null) {
            request.setIdCommission(1);
            this.log.error((Object)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044f");
        } else {
            request.setIdCommission(operation.getCommission().getId());
        }
        request.setIdOperation(operation.getIdOperation());
        request.setIdService(operation.getService().getId());
        request.setKeeper(keeper);
        request.setPinCode(operation.getPinCode());
        request.setSumResult(operation.getSumResult());
        request.setPaymentTool(operation.getPaymentTool());
        if (operation.getChildOperations() != null) {
            ArrayList<ChildOperationStub> childStubs = new ArrayList<ChildOperationStub>(operation.getChildOperations().size());
            for (ChildOperation child : operation.getChildOperations()) {
                ChildOperationStub cs = new ChildOperationStub((short)child.getService().getId(), child.getSumOutcome(), child.getForm(), child.getCommission(), child.getIdOperation(), child.getCheckNumber());
                cs.setInputElements(WSUtils.inputElementsToStub(child.getInputElements()));
                childStubs.add(cs);
            }
            request.setChilds(childStubs);
        }
        return request;
    }

    @Override
    public boolean sendNetworkStatistics(NetworkStatistics[] statistics) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            NetworkStatisticsRequest request = new NetworkStatisticsRequest();
            request.setStatistics(statistics);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.networkStatistics(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public PayerResponse getPayerId(Map<String, String> form, int service) throws ConnectorException {
        form.put("Request.Service", Integer.toString(service));
        return this.getPayerId(form);
    }

    @Override
    public boolean sendActivateStatus(CbcStatus[] status) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            CbcStatusRequest req = new CbcStatusRequest();
            req.setStatuses(status);
            boolean result = service.cbcStatus(req, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendUpdateState(ru.softlogic.srv.api.status.UpdateState state) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            UpdateState st = new UpdateState();
            st.setType(state.getType());
            st.setState(state.getState());
            boolean result = service.updateState(st, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public Operation checkCopy(long idOperation, String pin) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            CheckCopyRequest ccr = new CheckCopyRequest();
            ccr.setIdOperation(idOperation);
            ccr.setPin(pin);
            OperationCopyResult result = service.checkCopy(ccr, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            if (result == null || result.getOperations() == null || result.getOperations().length == 0) {
                return null;
            }
            Operation res = new Operation();
            OperationCopy r = result.getOperations()[0];
            res.setCheckNumber(r.getCheckNumber());
            res.setCommission(r.getCommission());
            res.setIdOperation(r.getIdOperation());
            res.setPinCode(r.getPinCode());
            res.setPinCodeNominal(r.getPinCodeNominal());
            res.setService(r.getService());
            res.setSumResult(r.getSumResult());
            res.setPoint(r.getPoint());
            res.setDealer(r.getDealer());
            res.setDate(r.getDate());
            KeeperStub ks = r.getKeeper();
            if (ks != null) {
                Keeper k = new Keeper();
                if (ks.getCashBackCards() != null) {
                    for (CashBackCardStub cashBackCardStub : ks.getCashBackCards()) {
                        k.addCashBackCard(new CashBackCard(cashBackCardStub.getId(), cashBackCardStub.getNominal()));
                    }
                }
                if (ks.getCashUnits() != null) {
                    for (Map.Entry entry : ks.getCashUnits().entrySet()) {
                        if (entry.getValue() == null) continue;
                        k.addCash(new CashUnit(((CashUnitStub)entry.getKey()).getId(), ((CashUnitStub)entry.getKey()).getNominal(), ((CashUnitStub)entry.getKey()).getType()), ((Integer)entry.getValue()).intValue());
                    }
                }
                res.setKeeper(k);
            }
            if (r.getForm() != null) {
                res.getForm().putAll(r.getForm());
            }
            if (r.getTitles() != null) {
                res.getTitles().putAll(r.getTitles());
            }
            if (r.getViews() != null) {
                res.getViews().putAll(r.getViews());
            }
            if (r.getInputElements() != null) {
                res.getInputElements().putAll(WSUtils.stubToInputElements(r.getInputElements()));
            }
            return res;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public int getPaymentsAmount(String account, int serviceId, Short pointId, int promoId, int sum, Date lastPayment) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            ClientPaymentRequest cpr = new ClientPaymentRequest();
            cpr.setAccount(account);
            cpr.setPoint(pointId == null ? (short)0 : pointId);
            cpr.setSid((short)serviceId);
            cpr.setIdPromo(promoId);
            cpr.setSum(sum);
            cpr.setLastPayment(lastPayment);
            int result = service.clientPayments(cpr, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public BonusResult registerBonus(String account, int idBonus, int sum, Date lastPayment) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            BonusRequest cpr = new BonusRequest();
            cpr.setAccount(account);
            cpr.setIdBonus(idBonus);
            cpr.setSum(sum);
            cpr.setLastPayment(lastPayment);
            BonusResult result = service.registerBonus(cpr, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public int useBonus(String account) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            int result = service.useBonus(account, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    public Response<ru.softlogic.input.model.Data> request(ru.softlogic.input.model.advanced.actions.request.RequestData data) throws ru.softlogic.input.model.advanced.actions.request.ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 advanced \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            RequestData rd = new RequestData();
            rd.setServiceId(data.getIdService());
            rd.setElements(WSUtils.convert(data.getParamsIe()));
            rd.setFunction(data.getFunction());
            rd.setProviderId(data.getIdProvider());
            Holder holder = new Holder((Object)header);
            BusinessService serv = this.getBusinessService(serverAddress, "https");
            AdvancedResponse result = serv.arequest(rd, (Holder<PackageHeader>)holder);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.notifyStatus(false);
            this.addressSelector.updateState(serverAddress, false);
            ru.softlogic.input.model.Data dest = null;
            if (result.getData() != null) {
                dest = new ru.softlogic.input.model.Data();
                this.fillData(dest, result.getData());
            }
            return new Response(result.getServerError(), result.getServiceError(), (Object)dest);
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ru.softlogic.input.model.advanced.actions.request.ConnectorException((Throwable)ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ru.softlogic.input.model.advanced.actions.request.ConnectorException((Throwable)ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ru.softlogic.input.model.advanced.actions.request.ConnectorException((Throwable)ex);
        }
    }

    private void fillData(ru.softlogic.input.model.Data dest, Data source) {
        dest.setElements(new LinkedList());
        if (source.getElements() != null) {
            for (InputElement ie : source.getElements()) {
                ru.softlogic.input.model.InputElement element = new ru.softlogic.input.model.InputElement(ie.getKey(), ie.getKeyTitle(), ie.getValue(), ie.getValueTitle(), 0);
                element.setOriginalValue(ie.getOriginalValue());
                element.setFlags(ie.getFlags() == null ? 0 : ie.getFlags());
                dest.getElements().add(element);
            }
        }
        if (source.getSum() != null) {
            dest.setSum(new TransactionSum(source.getSum().getSum()));
        }
        if (source.getData() != null) {
            NestedData nd = new NestedData();
            nd.setId(source.getData().getId());
            nd.setData(new LinkedList());
            if (source.getData().getData() != null) {
                for (Data newSource : source.getData().getData()) {
                    ru.softlogic.input.model.Data newDest = new ru.softlogic.input.model.Data();
                    this.fillData(newDest, newSource);
                    nd.getData().add(newDest);
                }
            }
            dest.setNestedData(nd);
        }
        if (source.getFeeSum() != null) {
            FeeSum feeSum = new FeeSum();
            feeSum.setFee(source.getFeeSum().getFee());
            feeSum.setFeeName(source.getFeeSum().getFeeName());
            feeSum.setFeePercent(source.getFeeSum().getFeePercent());
            dest.setFeeSum(feeSum);
        }
    }

    @Override
    public VerifyResult forceVerify(Service service, Map<String, ru.softlogic.input.model.InputElement> data) throws ConnectorException {
        return this.verify(service, data);
    }

    @Override
    public boolean sendEnvRiskFactors(EnvRiskFactors erf) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.registrationRiskFactors(erf, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendSystemInfo(SystemInfo[] infos) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            SystemInfoRequest request = new SystemInfoRequest();
            request.setInfos(infos);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.systemInfo(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendBoxInfos(BoxInfo[] infos) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            BoxInfoRequest request = new BoxInfoRequest();
            request.setBoxInfos(infos);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.boxInfo(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendBoxAmounts(BoxAmount[] amounts) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            BoxAmountRequest request = new BoxAmountRequest();
            request.setBoxAmounts(amounts);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.boxAmount(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendBoxStatuses(BoxStatus[] statuses) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            BoxStatusRequest request = new BoxStatusRequest();
            request.setBoxStatuses(statuses);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.boxStatus(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.log.error((Object)("Web service exception: " + (Object)((Object)ex)));
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.addressSelector.updateState(serverAddress, true);
            this.notifyStatus(true);
            throw new ConnectorException(ex);
        }
    }

    @Override
    public boolean sendZReportInfos(ZReportInfo[] infos) throws ConnectorException {
        ServerAddress serverAddress = this.addressSelector.getAddress();
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            ZReportInfoRequest request = new ZReportInfoRequest();
            request.setInfo(infos);
            Holder holder = new Holder((Object)header);
            String scheme = "https";
            try {
                PointOptions po = ReferenceManager.getInstance().getPointOptions();
                if (po.getTransportType() == TransportType.Http || po.getTransportType() == TransportType.HttpWithoutOperations) {
                    scheme = "http";
                }
            }
            catch (ReferenceException re) {
                this.log.error((Object)re, (Throwable)re);
            }
            BusinessService service = this.getBusinessService(serverAddress, scheme);
            boolean result = service.registerZreport(request, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return result;
        }
        catch (SOAPFaultException ex) {
            this.log.error((Object)ex.getMessage());
            throw new ConnectorException(ex);
        }
        catch (WebServiceException ex) {
            this.notifyStatus(true);
            this.addressSelector.updateState(serverAddress, true);
            this.log.error((Object)("Web service exception, error count " + this.addressSelector.getErrorCount(serverAddress)));
            throw new ConnectorException(ex);
        }
        catch (Exception ex) {
            this.log.error((Object)"Other error: ", (Throwable)ex);
            this.notifyStatus(true);
            this.addressSelector.updateState(serverAddress, true);
            throw new ConnectorException(ex);
        }
    }

    private PackageHeader createHeader() throws ReferenceException {
        PackageHeader header = new PackageHeader();
        header.setPoint(this.point);
        TerminalState ts = this.stateWatcher.getTerminalState();
        header.setTerminalState(ts == null ? 0 : ts.getErrorCode());
        header.setSignature("sign");
        header.setReferenceVersion(ReferenceManager.getInstance().getVersion());
        return header;
    }

    private boolean servicePing(String schema, ServerAddress serverAddress) {
        this.log.info((Object)("\u041e\u0442\u043f\u0440\u0430\u0432\u043b\u044f\u0435\u043c \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e \u0430\u0434\u0440\u0435\u0441\u0443: " + serverAddress));
        try {
            PackageHeader header = this.createHeader();
            Holder holder = new Holder((Object)header);
            BusinessService service = this.getBusinessService(serverAddress, schema);
            boolean result = service.ping(1, (Holder<PackageHeader>)holder);
            this.notifyStatus(false);
            this.notifyRefVersion(((PackageHeader)holder.value).getReferenceVersion());
            this.notifyRemoteStatus(((PackageHeader)holder.value).getStatus());
            this.addressSelector.updateState(serverAddress, false);
            return true;
        }
        catch (Throwable ex) {
            this.log.error((Object)ex.getMessage());
            return false;
        }
    }

    @Override
    public void checkServerAddresses() {
        List<ServerAddress> errorAddresses = this.addressSelector.getErrorAddresses();
        for (ServerAddress sa : errorAddresses) {
            this.log.info((Object)("\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u044e " + sa));
            if (!this.useHttpsPing) {
                if (this.servicePing("http", sa)) continue;
                this.servicePing("https", sa);
                continue;
            }
            this.servicePing("https", sa);
        }
    }
}

