/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.connector;

import java.util.HashSet;
import java.util.Set;
import ru.softlogic.reference.adv.Banner;
import ru.softlogic.srv.api.adv.BannerObserver;
import ru.softlogic.srv.connector.OfflineInterface;
import ru.softlogic.srv.connector.OnlineInterface;
import ru.softlogic.system.util.network.NetObserver;
import ru.softlogic.system.util.network.RefVersionObserver;
import ru.softlogic.system.util.network.RemoteStatusObserver;

public abstract class ServerInterface
implements OnlineInterface,
OfflineInterface {
    private Set<NetObserver> netObservers = new HashSet<NetObserver>();
    private Set<RemoteStatusObserver> remoteStatusObservers = new HashSet<RemoteStatusObserver>();
    private Set<RefVersionObserver> refVersionObservers = new HashSet<RefVersionObserver>();
    private Set<BannerObserver> bannerObservers = new HashSet<BannerObserver>();

    public boolean addNetObserver(NetObserver observer) {
        if (observer == null) {
            return false;
        }
        return this.netObservers.add(observer);
    }

    protected void notifyStatus(boolean netError) {
        for (NetObserver observer : this.netObservers) {
            observer.update(netError);
        }
    }

    public boolean addRemoteStatusObserver(RemoteStatusObserver observer) {
        if (observer == null) {
            return false;
        }
        return this.remoteStatusObservers.add(observer);
    }

    protected void notifyRemoteStatus(int remoteStatus) {
        for (RemoteStatusObserver observer : this.remoteStatusObservers) {
            observer.update(remoteStatus);
        }
    }

    public boolean addRefVersionObserver(RefVersionObserver observer) {
        if (observer == null) {
            return false;
        }
        return this.refVersionObservers.add(observer);
    }

    protected void notifyRefVersion(long version) {
        for (RefVersionObserver observer : this.refVersionObservers) {
            observer.update(version);
        }
    }

    public boolean addBannerObserver(BannerObserver observer) {
        if (observer == null) {
            return false;
        }
        return this.bannerObservers.add(observer);
    }

    protected void notifyBanners(Banner[] banners) {
        for (BannerObserver observer : this.bannerObservers) {
            observer.update(banners);
        }
    }

    public abstract void checkServerAddresses();
}

