/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.srv.api.security;

import java.util.Arrays;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import ru.softlogic.srv.api.oth.FileInfo;
import ru.softlogic.srv.api.security.SystemService;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EnvRiskFactors")
public class EnvRiskFactors {
    public static final int FACTOR_BASE = 0;
    public static final int FACTOR_HAS_SERIAL_VIRTUAL_PORTS = 1;
    public static final int FACTOR_HAS_SERIAL_SNIFFERS = 2;
    @XmlAttribute(name="f")
    private int factors;
    @XmlElement(name="sf")
    private FileInfo[] suspiciousFiles;
    @XmlElement(name="s")
    private SystemService[] services;
    @XmlElementWrapper(name="p")
    private Map<String, String> ports;

    public EnvRiskFactors() {
    }

    public EnvRiskFactors(int factors, FileInfo[] suspiciousFiles, SystemService[] services, Map<String, String> ports) {
        this.factors = factors;
        this.suspiciousFiles = suspiciousFiles;
        this.services = services;
        this.ports = ports;
    }

    public int getFactors() {
        return this.factors;
    }

    public FileInfo[] getSuspiciousFiles() {
        return this.suspiciousFiles;
    }

    public SystemService[] getServices() {
        return this.services;
    }

    public Map<String, String> getPorts() {
        return this.ports;
    }

    public String toString() {
        return "EnvRiskFactors{factors=" + this.factors + ", suspiciousFiles=" + Arrays.toString(this.suspiciousFiles) + ", services=" + Arrays.toString(this.services) + ", ports=" + this.ports + '}';
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + this.factors;
        hash = 37 * hash + Arrays.deepHashCode(this.suspiciousFiles);
        hash = 37 * hash + Arrays.deepHashCode(this.services);
        hash = 37 * hash + (this.ports != null ? this.ports.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnvRiskFactors other = (EnvRiskFactors)obj;
        if (this.factors != other.factors) {
            return false;
        }
        if (!Arrays.deepEquals(this.suspiciousFiles, other.suspiciousFiles)) {
            return false;
        }
        if (!Arrays.deepEquals(this.services, other.services)) {
            return false;
        }
        return this.ports == other.ports || this.ports != null && this.ports.equals(other.ports);
    }
}

