/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.encashment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.srv.connector.ws.stub.Encashment;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;
import ru.softlogic.system.util.PathUtils;

public class EncashmentStore {
    private final String file = PathUtils.getAppHome() + "/data/encashments.obj";
    private static EncashmentStore instance;
    private final Logger log = Logger.getLogger((String)"app");
    private List<Encashment> encashments;

    private EncashmentStore() {
        this.log.setAdditivity(false);
        this.readData(this.file);
    }

    public static EncashmentStore getInstance() {
        if (instance == null) {
            instance = new EncashmentStore();
        }
        return instance;
    }

    public synchronized Encashment[] getEncashments() {
        return this.encashments.toArray(new Encashment[this.encashments.size()]);
    }

    public synchronized void remove(Encashment encashment) {
        this.encashments.remove(encashment);
        this.saveData();
    }

    public synchronized void add(List<Encashment> encashments) {
        this.encashments.addAll(encashments);
        this.saveData();
    }

    public synchronized void update(Encashment element) {
        int index = this.encashments.indexOf(element);
        if (index < 0) {
            throw new IllegalArgumentException("Element did'not found in storage");
        }
        this.encashments.set(index, element);
        this.saveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readData(String file) {
        ObjectInputStream ois;
        block7: {
            File f;
            try {
                f = FileUtil.checkFile((String)file);
            }
            catch (FileUtilException ex) {
                throw new IllegalArgumentException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u044b\u0445 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0439", ex);
            }
            ois = null;
            try {
                ois = new ObjectInputStream(new FileInputStream(f));
                Object obj = ois.readObject();
                if (!(obj instanceof List)) break block7;
                this.encashments = (List)obj;
            }
            catch (Exception ex) {
                try {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u044b\u0445 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0439 \u0441 \u0434\u0438\u0441\u043a\u0430", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(ois);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)ois);
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        if (this.encashments == null) {
            this.encashments = new ArrayList<Encashment>();
        }
    }

    private void saveData() {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(this.file));
            oos.writeObject(this.encashments);
        }
        catch (Exception ex) {
            try {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u043d\u044b\u0445 \u0438\u043d\u043a\u0430\u0441\u0441\u0430\u0446\u0438\u0439 \u043d\u0430 \u0434\u0438\u0441\u043a", (Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(oos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)oos);
        }
        IOUtils.closeQuietly((OutputStream)oos);
    }
}

