/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.softlogic.srv.api.command.Command;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;

public class CommandStore {
    private File file;
    private Set<Command> commands;
    private Logger log;

    public CommandStore(String fileName) {
        this.readData(fileName);
        this.log = Logger.getLogger((String)"app");
        this.log.setAdditivity(false);
    }

    public synchronized void add(Command[] newCommands) {
        this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043d\u043e\u0432\u044b\u0435 \u043a\u043e\u043c\u043c\u0430\u043d\u0434\u044b \u0432 \u0445\u0440\u0430\u043d\u0438\u043b\u0438\u0449\u0435: " + Arrays.toString(newCommands)));
        if (newCommands != null && newCommands.length > 0) {
            this.commands.addAll(Arrays.asList(newCommands));
            this.saveData();
        }
    }

    public synchronized Command[] get() {
        return this.commands.toArray(new Command[this.commands.size()]);
    }

    public synchronized void remove(Command cmd) {
        if (cmd != null) {
            this.commands.remove(cmd);
            this.saveData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readData(String fileName) {
        try {
            this.file = FileUtil.checkFile((String)fileName);
        }
        catch (FileUtilException ex) {
            throw new IllegalArgumentException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 CommandStore", ex);
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(this.file));
            Object obj = ois.readObject();
            if (obj instanceof HashSet) {
                this.commands = (HashSet)obj;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.commands == null) {
            this.commands = new HashSet<Command>();
        }
    }

    private void saveData() {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(this.file));
            oos.writeObject(this.commands);
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u043a\u043e\u043c\u043c\u0430\u043d\u0434 \u043d\u0430 \u0434\u0438\u0441\u043a", (Throwable)ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

