/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.command;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class ArchBuilder {
    private File zipFile;
    private ZipOutputStream zos;
    private Logger log = Logger.getLogger((String)"app");

    public ArchBuilder() throws IOException {
        this.log.setAdditivity(false);
        try {
            this.zipFile = File.createTempFile("softlogic", ".zip");
            this.zos = new ZipOutputStream(new FileOutputStream(this.zipFile));
            this.zos.setLevel(9);
        }
        catch (IOException ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430", (Throwable)ex);
            if (this.zos != null) {
                try {
                    this.zos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new IOException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0432\u0440\u0435\u043c\u0435\u043d\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String label) {
        if (label != null) {
            ZipEntry ze = new ZipEntry("label.txt");
            try {
                this.zos.putNextEntry(ze);
                this.zos.write(label.getBytes(), 0, label.getBytes().length);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.zos.closeEntry();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(String name, String path) throws IOException {
        this.log.info((Object)("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0444\u0430\u0439\u043b: " + path + ", \u0438\u043c\u044f \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u044f: " + name));
        byte[] buf = new byte[1000];
        File file = new File(path);
        if (file.canRead()) {
            ZipEntry ze = new ZipEntry(name);
            InputStream is = null;
            try {
                int read;
                this.zos.putNextEntry(ze);
                is = new BufferedInputStream(new FileInputStream(path));
                while ((read = is.read(buf)) >= 0) {
                    this.zos.write(buf, 0, read);
                }
            }
            catch (Exception ex) {
                this.log.error((Object)"\u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u0443\u043f\u0430\u043a\u043e\u0432\u043a\u0435 \u0444\u0430\u0439\u043b\u0430", (Throwable)ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
                try {
                    this.zos.closeEntry();
                }
                catch (Exception exception) {}
            }
        }
    }

    public File finish() {
        if (this.zos != null) {
            try {
                this.zos.close();
                this.zos = null;
                return this.zipFile;
            }
            catch (IOException ex) {
                this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0444\u0430\u0439\u043b\u0430", (Throwable)ex);
            }
        }
        return null;
    }
}

