/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.statistic;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;
import ru.softlogic.statistic.PromoStatistic;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;

public class PromoStatisticStore {
    private File file;
    private PromoStatistic promoStatistic;
    private final Logger log;
    private static PromoStatisticStore store;

    private PromoStatisticStore(String fileName) {
        this.readData(fileName);
        this.log = Logger.getLogger((String)"app");
        this.log.setAdditivity(false);
    }

    public static synchronized PromoStatisticStore getInstance(String path) {
        if (store == null) {
            store = new PromoStatisticStore(path);
        }
        return store;
    }

    public synchronized PromoStatistic getPromoStatistic() {
        return this.promoStatistic;
    }

    public synchronized void setPromoStatistic(PromoStatistic statistic) {
        this.log.info((Object)("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u044e \u043f\u0440\u043e\u043c\u043e-\u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443: " + statistic));
        this.promoStatistic = statistic;
        this.saveData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readData(String fileName) {
        try {
            this.file = FileUtil.checkFile((String)fileName);
        }
        catch (FileUtilException ex) {
            throw new IllegalArgumentException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 StatisticStore", ex);
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(this.file));
            Object obj = ois.readObject();
            if (obj instanceof PromoStatistic) {
                this.promoStatistic = (PromoStatistic)obj;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void saveData() {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(this.file));
            oos.writeObject(this.promoStatistic);
        }
        catch (Exception ex) {
            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0438\u0441\u0438 \u043f\u0440\u043e\u043c\u043e\u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438 \u043d\u0430 \u0434\u0438\u0441\u043a", (Throwable)ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

