/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.statistic;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PromoStatistic
implements Serializable {
    static final long serialVersionUID = 1286502212271864338L;
    private Date period;
    private int sumTotal;
    private int sumComm;
    private int sumPrize;
    private final String sdf = "dd.MM.yyyy";

    public Date getPeriod() {
        return this.period;
    }

    public int getSumComm() {
        return this.sumComm;
    }

    public int getSumPrize() {
        return this.sumPrize;
    }

    public int getSumTotal() {
        return this.sumTotal;
    }

    public void setPeriod(Date period) {
        this.period = period;
    }

    public void setSumComm(int sumComm) {
        this.sumComm = sumComm;
    }

    public void setSumPrize(int sumPrize) {
        this.sumPrize = sumPrize;
    }

    public void setSumTotal(int sumTotal) {
        this.sumTotal = sumTotal;
    }

    public void updateSums(Date date, int addTotal, int addComm) {
        if (date == null) {
            throw new NullPointerException("date can not be null");
        }
        if (this.period == null || !this.getDateFormatter().format(date).equals(this.getDateFormatter().format(this.period))) {
            this.period = date;
            this.sumComm = addComm;
            this.sumTotal = addTotal;
            this.sumPrize = 0;
        } else {
            this.period = date;
            this.sumComm += addComm;
            this.sumTotal += addTotal;
        }
    }

    public SimpleDateFormat getDateFormatter() {
        return new SimpleDateFormat("dd.MM.yyyy");
    }

    public String toString() {
        return "PromoStatistic{period=" + this.period + ", sumTotal=" + this.sumTotal + ", sumComm=" + this.sumComm + ", sumPrize=" + this.sumPrize + '}';
    }
}

