/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.service.comission;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="FeeSum")
public class FeeSum
implements Serializable {
    static final long serialVersionUID = 2440727064982518595L;
    public static int defaultFractionDigits = 2;
    @XmlAttribute(name="fee")
    private int fee;
    @XmlAttribute(name="feeName")
    private String feeName;
    @XmlAttribute(name="feePercent")
    private double feePercent;

    public FeeSum() {
    }

    public FeeSum(int fee, String feeName, double feePercent) {
        this.fee = fee;
        this.feeName = feeName;
        this.feePercent = feePercent;
    }

    public FeeSum(float ffee) {
        this.fee = (int)Math.round((double)ffee * Math.pow(10.0, defaultFractionDigits));
    }

    public FeeSum(double ffee, String feeName, double feePercent) {
        this.fee = (int)Math.round(ffee * Math.pow(10.0, defaultFractionDigits));
        this.feeName = feeName;
        this.feePercent = feePercent;
    }

    public static int getDefaultFractionDigits() {
        return defaultFractionDigits;
    }

    public static void setDefaultFractionDigits(int defaultFractionDigits) {
        FeeSum.defaultFractionDigits = defaultFractionDigits;
    }

    public int getFee() {
        return this.fee;
    }

    public void setFee(int fee) {
        this.fee = fee;
    }

    public String getFeeName() {
        return this.feeName;
    }

    public void setFeeName(String feeName) {
        this.feeName = feeName;
    }

    public double getFeePercent() {
        return this.feePercent;
    }

    public void setFeePercent(double feePercent) {
        this.feePercent = feePercent;
    }

    public String toString() {
        return "FeeSum{fee=" + this.fee + ", feeName=" + this.feeName + ", feePercent=" + this.feePercent + '}';
    }
}

