/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.service.comission;

import java.io.Serializable;
import java.util.HashSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ru.softlogic.cash.Sum;
import ru.softlogic.service.comission.CommissionNominal;
import ru.softlogic.service.comission.CommissionStep;
import ru.softlogic.service.comission.CommissionType;
import ru.softlogic.service.comission.CommissionUnit;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Commission")
public class Commission
implements Serializable {
    static final long serialVersionUID = -8634451698859229975L;
    @XmlAttribute(name="id")
    private int id;
    @XmlAttribute(name="name")
    private String name;
    @XmlAttribute(name="type")
    private CommissionType type = CommissionType.Direct;
    @XmlElement(name="min")
    private Sum min;
    @XmlElement(name="max")
    private Sum max;
    @XmlElement(name="steps")
    private TreeSet<CommissionStep> steps;
    @XmlElement(name="units")
    private HashSet<CommissionUnit> units;
    @XmlElement(name="nominals")
    private HashSet<CommissionNominal> nominals;
    @XmlElement(name="round")
    private Sum roundOrder;
    @XmlAttribute(name="percent")
    private double percentValue;
    @XmlElement(name="fixed")
    private Sum fixedValue;
    @XmlAttribute(name="useTiming")
    private Boolean useTiming;
    @XmlAttribute(name="separateUTC")
    private Boolean separateUnitTypesCalc;

    public Commission() {
    }

    public Commission(int id) {
        this.id = id;
    }

    public Commission(int id, String name, CommissionType type, double percent) {
        this(id);
        this.setName(name);
        this.setType(type);
        this.setPercentValue(percent);
        this.setRoundOrder(null);
    }

    public Commission(int id, String name, CommissionType type, double percent, Sum fixed) {
        this(id);
        this.setName(name);
        this.setType(type);
        this.setPercentValue(this.percentValue);
        this.setFixedValue(this.fixedValue);
        this.setRoundOrder(null);
    }

    public Commission(int id, String name, CommissionType type, Sum min, Sum max, Sum roundOrder, double percent, Sum fixed, TreeSet<CommissionStep> commissionSteps) {
        this(id);
        this.setName(name);
        this.setType(type);
        this.setMin(min);
        this.setMax(max);
        this.setRoundOrder(roundOrder);
        this.setPercentValue(percent);
        this.setFixedValue(fixed);
        this.setSteps(commissionSteps);
    }

    public int getId() {
        return this.id;
    }

    public void setMax(Sum max) {
        this.max = max;
    }

    public Sum getMax() {
        return this.max;
    }

    public void setMin(Sum min) {
        this.min = min;
    }

    public Sum getMin() {
        return this.min;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043c\u0438\u0441\u0441\u0438\u0438 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c null");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setSteps(TreeSet<CommissionStep> steps) {
        this.steps = steps;
    }

    public TreeSet<CommissionStep> getSteps() {
        return this.steps;
    }

    public void setType(CommissionType type) {
        this.type = type;
    }

    public CommissionType getType() {
        return this.type;
    }

    public void setRoundOrder(Sum roundOrder) {
        this.roundOrder = roundOrder;
    }

    public Sum getRoundOrder() {
        return this.roundOrder;
    }

    public Sum getFixedValue() {
        return this.fixedValue;
    }

    public void setFixedValue(Sum fixedValue) {
        this.fixedValue = fixedValue;
    }

    public double getPercentValue() {
        return this.percentValue;
    }

    public void setPercentValue(double percentValue) {
        this.percentValue = percentValue;
    }

    public HashSet<CommissionUnit> getUnits() {
        return this.units;
    }

    public void setUnits(HashSet<CommissionUnit> units) {
        this.units = units;
    }

    public Boolean getUseTiming() {
        return this.useTiming;
    }

    public void setUseTiming(Boolean useTiming) {
        this.useTiming = useTiming;
    }

    public Boolean getSeparateUnitTypesCalc() {
        return this.separateUnitTypesCalc;
    }

    public void setSeparateUnitTypesCalc(Boolean separateUnitTypesCalc) {
        this.separateUnitTypesCalc = separateUnitTypesCalc;
    }

    public HashSet<CommissionNominal> getNominals() {
        return this.nominals;
    }

    public void setNominals(HashSet<CommissionNominal> nominals) {
        this.nominals = nominals;
    }

    public String toString() {
        return "Comission[id=" + this.id + ", name=" + this.name + ",min=" + this.min + ",max=" + this.max + ",type=" + (Object)((Object)this.type) + ",round=" + this.roundOrder + ",perc=" + this.percentValue + ",fixed=" + this.fixedValue + ",steps=" + this.steps + ",units=" + this.units + "]";
    }

    public boolean isSimple() {
        return !(this.steps != null && !this.steps.isEmpty() || this.units != null && !this.units.isEmpty());
    }

    public boolean isFixedValueNotEmpty() {
        return this.fixedValue != null && !this.fixedValue.isEmpty();
    }

    public boolean isStepsNotEmpty() {
        return this.steps != null && !this.steps.isEmpty();
    }

    public boolean hasBounds() {
        return this.max != null && !this.max.isEmpty() || this.min != null && !this.min.isEmpty();
    }

    public boolean isEmpty() {
        boolean isNominalsEmpty = this.nominals == null || !this.nominals.isEmpty();
        boolean hasPercentFixedValue = this.percentValue > 0.0 && this.fixedValue != null && !this.fixedValue.isEmpty();
        return !hasPercentFixedValue && this.isSimple() && !this.hasBounds() && isNominalsEmpty;
    }
}

