/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.reference.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ru.softlogic.reference.menu.MenuGroupKey;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.service.ScreenType;
import ru.softlogic.reference.service.ServiceTypeLang;

public class ServiceType
implements Serializable {
    static final long serialVersionUID = 2570599596431724224L;
    private int id;
    private String name;
    private String image;
    private String style;
    private short sortOrder;
    private Map<String, ServiceTypeLang> langs;
    private MenuItem[] menuItems;
    private ServiceType[] types;
    private String invitation;
    private ScreenType screenType;
    private Short hotkeyPosition;
    private Boolean blocked;
    private String desc;
    private Integer label;
    private boolean hidden;
    private List<MenuGroupKey> menuGroupKeys;

    public ServiceType(String name) {
        this.name = name;
    }

    public ServiceType(ServiceType[] types) {
        this.types = types;
    }

    public ServiceType() {
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public Map<String, ServiceTypeLang> getLangs() {
        return this.langs;
    }

    public void setLangs(Map<String, ServiceTypeLang> langs) {
        this.langs = langs;
    }

    public MenuItem[] getMenuItems() {
        return this.menuItems;
    }

    public void setMenuItems(MenuItem[] menuItems) {
        this.menuItems = menuItems;
    }

    public MenuItem[] getVisibleMenuItems() {
        ArrayList<MenuItem> nTypes = new ArrayList<MenuItem>();
        if (this.menuItems != null) {
            for (MenuItem st : this.menuItems) {
                if (st.isHideUnactive()) continue;
                nTypes.add(st);
            }
        }
        return nTypes.toArray(new MenuItem[nTypes.size()]);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServiceType[] getTypes() {
        return this.types;
    }

    public ServiceType[] getVisibleTypes() {
        ArrayList<ServiceType> nTypes = new ArrayList<ServiceType>();
        if (this.types != null) {
            for (ServiceType st : this.types) {
                if (st.getName() != null && (st.getName().startsWith("#") || st.getHidden())) continue;
                nTypes.add(st);
            }
        }
        return nTypes.toArray(new ServiceType[nTypes.size()]);
    }

    public void setTypes(ServiceType[] types) {
        this.types = types;
    }

    public short getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(short sortOrder) {
        this.sortOrder = sortOrder;
    }

    public String getInvitation() {
        return this.invitation;
    }

    public void setInvitation(String invitation) {
        this.invitation = invitation;
    }

    public ScreenType getScreenType() {
        return this.screenType;
    }

    public void setScreenType(ScreenType screenType) {
        this.screenType = screenType;
    }

    public Short getHotkeyPosition() {
        return this.hotkeyPosition;
    }

    public void setHotkeyPosition(Short hotkeyPosition) {
        this.hotkeyPosition = hotkeyPosition;
    }

    public Boolean getBlocked() {
        return this.blocked;
    }

    public void setBlocked(Boolean blocked) {
        this.blocked = blocked;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getLabel() {
        return this.label;
    }

    public void setLabel(Integer label) {
        this.label = label;
    }

    public boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public List<MenuGroupKey> getMenuGroupKeys() {
        return this.menuGroupKeys;
    }

    public void setMenuGroupKeys(List<MenuGroupKey> groupKeys) {
        this.menuGroupKeys = groupKeys;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof ServiceType) {
            ServiceType oth = (ServiceType)obj;
            return this.id == oth.id;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + this.id;
        hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "ServiceType[id=" + this.id + ",name=" + this.name + ",sort=" + this.sortOrder + ",lang=" + this.langs + ",screen=" + this.screenType + ",label=" + this.label + ",hidden=" + this.hidden + "]";
    }
}

