/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.reference;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import ru.softlogic.app.DaemonVersion;
import ru.softlogic.app.configuration.SystemProp;
import ru.softlogic.reference.ReferenceData;
import ru.softlogic.reference.ReferenceException;
import ru.softlogic.reference.adv.Banner;
import ru.softlogic.reference.adv.Bonus;
import ru.softlogic.reference.adv.CheckAdv;
import ru.softlogic.reference.adv.Movie;
import ru.softlogic.reference.adv.Promo;
import ru.softlogic.reference.bwlist.PersonalNumber;
import ru.softlogic.reference.currency.CurrencyRate;
import ru.softlogic.reference.currency.ProviderCurrencyRate;
import ru.softlogic.reference.email.Auth;
import ru.softlogic.reference.fraud.FraudControlRule;
import ru.softlogic.reference.menu.Menu;
import ru.softlogic.reference.menu.MenuItem;
import ru.softlogic.reference.menu.MenuItemState;
import ru.softlogic.reference.point.BINList;
import ru.softlogic.reference.point.Bank;
import ru.softlogic.reference.point.Dealer;
import ru.softlogic.reference.point.PaymentSystem;
import ru.softlogic.reference.point.Point;
import ru.softlogic.reference.point.PointOptions;
import ru.softlogic.reference.point.ServerUser;
import ru.softlogic.reference.service.Service;
import ru.softlogic.reference.service.ServiceType;
import ru.softlogic.reference.updater.UpdateOptions;
import ru.softlogic.reference.weather.Weather;
import ru.softlogic.srv.api.card.ServiceOptions;
import ru.softlogic.srv.connector.ServerAddress;
import ru.softlogic.statistic.CashAcceptorStatus;
import ru.softlogic.system.util.FileUtil;

public class ReferenceManager {
    private static ReferenceManager instance;
    private Logger log = Logger.getLogger((String)"app");
    private File dataFile;
    private ReferenceData data;
    private File moviesListFile;
    private String activeAddress;

    private ReferenceManager() throws ReferenceException {
        this.log.setAdditivity(false);
        if (SystemProp.getTerminalDir() == null) {
            throw new ReferenceException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0441\u0438\u0441\u0442\u0435\u043c\u043d\u043e\u0435 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e terminal.dir");
        }
        try {
            this.dataFile = FileUtil.checkFile((String)(SystemProp.getTerminalDir() + File.separator + "data" + File.separator + "references.obj"));
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            throw new ReferenceException(ex.getMessage());
        }
        try {
            this.moviesListFile = FileUtil.checkFile((String)(SystemProp.getTerminalDir() + File.separator + "ad" + File.separator + "playlist").replace("./", ""));
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        this.readData();
    }

    public static synchronized ReferenceManager getInstance() throws ReferenceException {
        if (instance == null) {
            instance = new ReferenceManager();
        }
        return instance;
    }

    public synchronized Dealer getDealer() {
        return this.data.getDealer();
    }

    public synchronized boolean isLocked() {
        return this.data.isLocked();
    }

    public synchronized void setDealer(Dealer dealer) {
        this.data.setDealer(dealer);
        this.updateData();
    }

    public synchronized Point getPoint() {
        return this.data.getPoint();
    }

    public synchronized void setPoint(Point point) {
        this.data.setPoint(point);
        this.updateData();
    }

    public synchronized PointOptions getPointOptions() {
        PointOptions pointOptions = this.data.getPointOptions();
        if (pointOptions != null) {
            return pointOptions;
        }
        return new PointOptions();
    }

    public synchronized void setPointOptions(PointOptions pointOptions) {
        this.data.setPointOptions(pointOptions);
        this.updateData();
    }

    public synchronized Menu getMenu() {
        return this.data.getMenu();
    }

    public synchronized void setMenu(Menu menu) {
        this.data.setMenu(menu);
        this.updateData();
    }

    public synchronized ServiceOptions[] getServiceOptions() {
        return this.data.getServiceOptions();
    }

    public synchronized void setServiceOptions(ServiceOptions[] serviceOptions) {
        this.data.setServiceOptions(serviceOptions);
        this.updateData();
    }

    public synchronized MenuItemState[] getMenuItemStates() {
        return this.data.getMenuItemStates();
    }

    public synchronized void setMenuItemStates(MenuItemState[] menuItemStates) {
        this.data.setMenuItemStates(menuItemStates);
        this.updateData();
    }

    public synchronized PersonalNumber[] getPersonalNumbers() {
        return this.data.getPersonalNumbers();
    }

    public PersonalNumber[] getPersonalNumbers(Service service) {
        if (this.data.getPersonalNumbers() == null || this.data.getPersonalNumbers() != null && this.data.getPersonalNumbers().length == 0) {
            return this.data.getPersonalNumbers();
        }
        ArrayList<PersonalNumber> numbers = new ArrayList<PersonalNumber>();
        for (PersonalNumber pn : this.data.getPersonalNumbers()) {
            if (pn.getService() != service.getId()) continue;
            numbers.add(pn);
        }
        if (numbers.isEmpty()) {
            for (PersonalNumber pn : this.data.getPersonalNumbers()) {
                if ((pn.getService() != 0 || pn.getServiceTypeId() == null || !pn.getServiceTypeId().equals(service.getServiceTypeId())) && (pn.getService() != 0 || pn.getServiceTypeId() != null)) continue;
                numbers.add(pn);
                break;
            }
        }
        return numbers.toArray(new PersonalNumber[numbers.size()]);
    }

    public synchronized void setPersonalNumbers(PersonalNumber[] personalNumbers) {
        this.data.setPersonalNumbers(personalNumbers);
        this.updateData();
    }

    public synchronized Banner[] getBanners() {
        return this.data.getBanners();
    }

    public synchronized Movie[] getMovies() {
        return this.data.getMovies();
    }

    public synchronized void setMovies(Movie[] movies) {
        this.data.setMovies(movies);
        this.updateData();
        this.generateMoviesList();
    }

    public synchronized void setBanners(Banner[] banners) {
        this.data.setBanners(banners);
        this.updateData();
    }

    public synchronized CheckAdv[] getCheckAdvs() {
        return this.data.getCheckAdvs();
    }

    public synchronized void setCheckAdvs(CheckAdv[] checkAdvs) {
        this.data.setCheckAdvs(checkAdvs);
        this.updateData();
    }

    public synchronized long getVersion() {
        return this.data.getVersion();
    }

    public synchronized void setVersion(long version) {
        this.data.setVersion(version);
        this.updateData();
    }

    public synchronized Auth getAuth() {
        return this.data.getAuth();
    }

    public synchronized void setAuth(Auth auth) {
        this.data.setAuth(auth);
        this.updateData();
    }

    public synchronized UpdateOptions getUpdateOptions() {
        return this.data.getUpdateOptions();
    }

    public synchronized void setUpdateOptions(UpdateOptions updateOptions) {
        this.data.setUpdateOptions(updateOptions);
        this.updateData();
    }

    public synchronized Bank getBank() {
        return this.data.getBank();
    }

    public synchronized void setBank(Bank bank) {
        this.data.setBank(bank);
        this.updateData();
    }

    public synchronized PaymentSystem getPaymentSystem() {
        return this.data.getPaymentSystem();
    }

    public synchronized void setPaymentSystem(PaymentSystem paymentSystem) {
        this.data.setPaymentSystem(paymentSystem);
        this.updateData();
    }

    public synchronized ServerAddress[] getServerAddresses() {
        return this.data.getServerAddresses();
    }

    public synchronized void setServerAddresses(ServerAddress[] serverAddresses) {
        this.data.setServerAddresses(serverAddresses);
        this.updateData();
    }

    public synchronized ServerUser[] getServerUsers() {
        return this.data.getServerUsers();
    }

    public synchronized void setServerUsers(ServerUser[] secretMenuUsers) {
        this.data.setServerUsers(secretMenuUsers);
        this.updateData();
    }

    public synchronized Promo[] getPromos() {
        return this.data.getPromos();
    }

    public synchronized void setPromos(Promo[] promo) {
        this.data.setPromos(promo);
        this.updateData();
    }

    public synchronized Bonus[] getBonuses() {
        return this.data.getBonuses();
    }

    public synchronized void setBonuses(Bonus[] bonuses) {
        this.data.setBonuses(bonuses);
        this.updateData();
    }

    public synchronized CurrencyRate[] getCurrencyRates() {
        return this.data.getCurrencyRates();
    }

    public synchronized void setCurrencyRates(CurrencyRate[] rates) {
        this.data.setCurrencyRates(rates);
        this.updateData();
    }

    public synchronized ProviderCurrencyRate[] getProviderCurrencyRates() {
        return this.data.getProviderCurrencyRates();
    }

    public synchronized void setProviderCurrencyRates(ProviderCurrencyRate[] providerCurrencyRates) {
        this.data.setProviderCurrencyRates(providerCurrencyRates);
        this.updateData();
    }

    public synchronized void updateChangedMenuItems(MenuItem[] changed) {
        Menu menu = this.data.getMenu();
        if (menu != null && changed != null && menu.getTypes() != null) {
            for (ServiceType st : menu.getTypes()) {
                this.updateChangedMenuItems(st, changed);
            }
        }
        this.updateData();
    }

    public synchronized void updateLockedStatus(boolean locked) {
        if (this.data.isLocked() != locked) {
            this.data.setLocked(locked);
            this.updateData();
        }
    }

    public synchronized Weather[] getWeakWeather() {
        if (this.data.getWeather() == null || this.data.getWeather().length == 0) {
            return this.data.getWeather();
        }
        ArrayList<Weather> result = new ArrayList<Weather>();
        Weather[] list = this.data.getWeather();
        int lastDay = 0;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int currentHour = calendar.get(11);
        if (list != null && list.length > 0) {
            for (Weather w : list) {
                calendar.setTime(w.getForecastDate() == null ? new Date() : w.getForecastDate());
                if (lastDay != 0 && (lastDay == calendar.get(5) || calendar.get(11) + 3 <= currentHour || calendar.get(11) > currentHour)) continue;
                lastDay = calendar.get(5);
                result.add(w);
            }
        }
        return result.toArray(new Weather[result.size()]);
    }

    public synchronized Weather[] getWeather() {
        return this.data.getWeather();
    }

    public synchronized void setWeather(Weather[] weather) {
        this.data.setWeather(weather);
        this.updateData();
    }

    public CashAcceptorStatus getCashAcceptorStatus() {
        return this.data.getCashAcceptorStatus();
    }

    public synchronized void setCashAcceptorStatus(CashAcceptorStatus cashAcceptorStatus) {
        this.data.setCashAcceptorStatus(cashAcceptorStatus);
        this.updateData();
    }

    public BINList getBinList() {
        return this.data.getBinList();
    }

    public void setBinList(BINList binList) {
        this.data.setBinList(binList);
        this.updateData();
    }

    public List<String> getPaymentSources() {
        return this.data.getPaymentSources();
    }

    public void setPaymentSources(List<String> paymentSources) {
        this.data.setPaymentSources(paymentSources);
        this.updateData();
    }

    public List<FraudControlRule> getFraudControlRules() {
        return this.data.getFraudControlRules();
    }

    public void setFraudControlRules(List<FraudControlRule> fraudControlRules) {
        this.data.setFraudControlRules(fraudControlRules);
        this.updateData();
    }

    public String getActiveAddress() {
        return this.activeAddress;
    }

    public void setActiveAddress(String activeAddress) {
        this.activeAddress = activeAddress;
    }

    private void updateChangedMenuItems(ServiceType st, MenuItem[] changed) {
        if (st != null) {
            if (st.getMenuItems() != null) {
                for (int i = 0; i < st.getMenuItems().length; ++i) {
                    MenuItem[] menuItemArray = changed;
                    int n = menuItemArray.length;
                    for (int j = 0; j < n; ++j) {
                        MenuItem mi = menuItemArray[j];
                        if (!st.getMenuItems()[i].equals(mi)) continue;
                        st.getMenuItems()[i] = mi;
                    }
                }
            }
            if (st.getTypes() != null) {
                for (ServiceType st1 : st.getTypes()) {
                    this.updateChangedMenuItems(st1, changed);
                }
            }
        }
    }

    public synchronized void clear() {
        this.data = new ReferenceData();
        this.updateData();
    }

    private void readData() {
        this.log.info((Object)"*************** \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0447\u0442\u0435\u043d\u0438\u0435 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432 ***************");
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(this.dataFile));
            Object obj = ois.readObject();
            if (obj instanceof ReferenceData) {
                this.data = (ReferenceData)obj;
            }
        }
        catch (Exception ex) {
            this.log.info((Object)ex.getMessage());
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.data == null) {
            this.data = new ReferenceData();
        }
        if (!DaemonVersion.version.equals(this.data.getSoftware())) {
            this.log.info((Object)("\u0412\u0435\u0440\u0441\u0438\u044f \u041f\u041e \u043e\u0442\u043b\u0438\u0447\u0430\u0435\u0442\u0441\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u043d\u043e\u0439. \u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043e\u0432. daemon=" + DaemonVersion.version + ", \u0441\u043e\u0445\u0440=" + this.data.getSoftware()));
            this.data.setVersion(0L);
        }
        this.log.info((Object)"********************* \u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b \u0447\u0442\u0435\u043d\u0438\u0435 *********************");
    }

    private void updateData() {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(this.dataFile));
            this.data.setSoftware(DaemonVersion.version);
            oos.writeObject(this.data);
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMoviesList() {
        PrintWriter pw = null;
        try {
            Movie[] movies = this.getMovies();
            if (movies != null) {
                pw = new PrintWriter(this.moviesListFile);
                for (Movie m : movies) {
                    if (m.getUrl() == null) continue;
                    pw.println(this.moviesListFile.getParentFile().getAbsolutePath() + File.separator + m.getUrl());
                }
            } else {
                pw = new PrintWriter(this.moviesListFile);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
        }
        finally {
            try {
                pw.close();
            }
            catch (Exception exception) {}
        }
    }
}

